#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "полчаса на dev7",
  comment => "можно перезапустить если упадет"
}

=cut

use Direct::Modern;

use List::MoreUtils qw/uniq/;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;
use Yandex::Retry qw/relaxed/;

use ScriptHelper;
use Settings;
use ShardingTools qw/ppc_shards/;
use User ();

$log->out('START');

for my $shard (ppc_shards()) {
    my $log_prefix_guard = $log->msg_prefix_guard("[shard $shard]");
    for my $table (@User::TABLES_TO_CLEAN_BY_CLIENTID) {
        $log->out("search obsolete data in table $table");
        my $obsolete_data = get_all_sql(PPC(shard => $shard), "SELECT t.* FROM $table t LEFT JOIN users u ON u.ClientID = t.ClientID WHERE t.ClientID > 0 AND u.ClientID IS NULL");
        $log->out({table => $table, data => $obsolete_data});
        my @clientids = uniq map { $_->{ClientID} } @$obsolete_data;
        next unless @clientids;
        for my $chunk (chunks(\@clientids, 100)) {
            relaxed times => 3, sub {
                $log->out("delete data chunk from table $table for ClientIDs: " . join(',', @$chunk));
                my $res = do_sql(PPC(shard => $shard), ["DELETE t FROM $table t LEFT JOIN users u ON u.ClientID = t.ClientID",
                                                        WHERE => {'u.ClientID__is_null' => 1, 't.ClientID__int' => $chunk}
                                                        ]);
                $log->out("deleted $res rows");
            };
        }

    }
}

$log->out('FINISH');

