#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "около минуты",
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use Settings;
use ScriptHelper;

$log->out('START');


my $script_path = my_inc::path('../protected/one-shot/stat_detailed_mark_to_refresh.pl');


$log->out('fetching orders for mobile_content campaigns with OrderID');
my $orders = get_one_column_sql(PPC(shard => 'all'), 'SELECT orderid FROM campaigns WHERE orderid > 0 AND type = "mobile_content"');
$log->out($orders);

$log->out('open stat_detailed_mark_to_refresh.pl');
open (my $fh, '|-', "$script_path --border-date 2015-08-16 --force --filter-orderids-from-stdin") or $log->die("can't fork: $!");

$log->out('pass orders list to script');
printf {$fh} '%s', join("\n", @$orders);

$log->out('execute stat_detailed_mark_to_refresh.pl');
close($fh) or $log->die("Can't close handle");

$log->out('FINISH');

