#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => 'минута',
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::TimeCommon;

use my_inc '..';

use ScriptHelper;
use Settings;

$log->out('START');

my %data;
my $shards = get_db_childs("ppcstat");

for my $shard (sort @$shards) {
    my $log_prefix_guard = $log->msg_prefix_guard("[$shard]");

    $log->out('start processing this shard');

    my $dbh = get_dbh($shard);

    # получаем список заказов, которые могли быть затронуты
    my $possible_orders = get_one_column_sql($dbh, 'SELECT OrderID FROM order_stat_info WHERE statStart < "2013-04-01 00:00:00"');

    $log->out(sprintf('got %d orders', scalar(@$possible_orders)));

    for my $orderid (@$possible_orders) {
        $log->out("check stat data for $orderid");

        $data{$orderid} = undef unless exists $data{$orderid};

        # проверяем кеш статистики этих заказов на предмет невалидных данных
        my $min_bad_date = get_one_field_sql($dbh, "SELECT MIN(hitDate) FROM ppcstat_data.order_stat_$orderid WHERE hitDate < '2013-04-01' AND ContextType = 8");
        
        if (defined $min_bad_date
            && (!defined $data{$orderid}
                || $min_bad_date lt $data{$orderid}
                )
        ) {
            $data{$orderid} = $min_bad_date;
        }
    }

    $log->out('finish processing this shard');
}


my @rollback_data;
for my $orderid (nsort keys %data) {
    if (!defined $data{$orderid}) {
        $log->out("$orderid stat data is OK");
    } else {
        $log->out("$orderid stat data has BAD records, need rollback. Minimum bad hitDate is $data{$orderid}");
        push @rollback_data, [$orderid, yesterday($data{$orderid}), ''];
    }
}

$log->out({rollback_data => \@rollback_data});

$log->out("Insert data into stat_rollbacks");
my $res =  do_mass_insert_sql(PPCDICT, 'INSERT INTO stat_rollbacks ( OrderID, border_date, hosts ) values %s', \@rollback_data);
$log->out("Inserted $res rows");

$log->out('FINISH');
