#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "ppc:all",
    when => 'before',
    time_estimate => "1 sec",
    sql => "CREATE TABLE `warn_pay` (
  `cid` int unsigned NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `warned_interval` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`),
  KEY (`warned_interval`, `create_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8"
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "20 sec",
    comment => "можно перезапускать"
  }
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;

use Settings;
use ScriptHelper;

$log->out('START');

my $rows = get_all_sql(PPCDICT, "SELECT cid, create_time, warned_interval FROM warn_pay WHERE create_time > now() - interval 7 day");
$log->out("selected ".scalar(@$rows)." rows");
foreach_shard cid => $rows, sub {
    my ($shard, $chunk) = @_;
    my $cnt = do_mass_insert_sql(PPC(shard => $shard), "INSERT IGNORE INTO warn_pay (cid, create_time, warned_interval) VALUES %s",
                       [map {[@{$_}{'cid', 'create_time', 'warned_interval'}]} @$chunk]
        );
    $log->out("inserted $cnt rows into shard $shard");
};

$log->out('FINISH');

