#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '10 секунд',
  comment => 'снимаем тизер у объединённых клиентов',
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Balance qw(balance_get_all_equal_clients);
use Yandex::ListUtils qw(nsort);

use Settings;
use ScriptHelper;

use List::MoreUtils qw(uniq);

$log->out('START');

$log->out('Fetching client aliases from Balance');
my $balance_aliases = balance_get_all_equal_clients();
$log->out('Got ' . scalar(@$balance_aliases) . ' alias pairs');
my @alias_clientids = uniq map { ($_->{CLIENT_ID}, $_->{CLASS_ID}) } @$balance_aliases;
undef $balance_aliases;

foreach_shard ClientID => [nsort @alias_clientids], chunk_size => 500, sub {
    my ($shard, $clientids) = @_;

    my $msg_prefix_guard = $log->msg_prefix_guard("[shard_$shard]");

    $log->out('Fetching clients data');
    my $clients_data = get_all_sql(PPC(shard => $shard), ['
        SELECT DISTINCT u.ClientID
             , fcc.*
             , ctfmt.*
        FROM users u
        LEFT JOIN clients cl ON u.ClientID = cl.ClientID
        INNER JOIN clients_to_force_multicurrency_teaser ctfmt ON u.ClientID = ctfmt.ClientID
        LEFT JOIN force_currency_convert fcc ON u.ClientID = fcc.ClientID
        LEFT JOIN currency_convert_queue q ON u.ClientID = q.ClientID
        WHERE
            IFNULL(cl.work_currency, "YND_FIXED") = "YND_FIXED"
            AND q.ClientID IS NULL
    ', 'AND', {'u.ClientID' => $clientids}
    ]);
    $log->out('Got ' . scalar(@$clients_data) . ' clients to remove teaser and possbile reset force currency convert:', $clients_data);

    my @clientsids_to_remove_teaser = uniq map {$_->{ClientID}} @$clients_data;
    if (@clientsids_to_remove_teaser) {
        $log->out('Deleting clients teasers and stopping force currency convert for ClientIDs:', \@clientsids_to_remove_teaser);
        do_update_table(PPC(shard => $shard), 'force_currency_convert', {
            convert_date => undef,
            country_region_id => undef,
            currency => undef,
        }, where => {ClientID => \@clientsids_to_remove_teaser});
        do_delete_from_table(PPC(shard => $shard), 'clients_to_force_multicurrency_teaser', where => {ClientID => \@clientsids_to_remove_teaser});
    }
};

$log->out('FINISH');
