#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
[
{
  type => 'sql',
  webstop => 0,
  db => 'ppc:all',
  when => 'before',
  time_estimate => '1 секунда',
  sql => qq{
    CREATE TABLE `users_typed_options` (
      `uid` bigint(20) NOT NULL,
      `type` enum('stat_report_master') NOT NULL,
      `options_json` mediumblob,
      PRIMARY KEY (`uid`,`type`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8
  },
},
{
  type => 'script',
  when => 'after',
  time_estimate => "1-2 минуты",
  comment => "Перекидывает некоторые настройки из users_options в users_typed_options.
На момент коммита миграции затрагивает порядка 400 пользователей.
При необходимости можно перезапускать.
"
}
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::HashUtils;

use Settings;
use ScriptHelper;
use User;


$log->out('START');

our $USER_OPTION_TYPE = 'stat_report_master';
our @TYPED_OPTION_NAMES = qw/stat_master_filters stat_master_reports/;

my $uids = get_one_column_sql(PPC(shard => 'all'), 'select uid from users_options where options like "%stat\_master\_%"');
for my $uid (@$uids) {
    $log->out("Start processing uid: $uid");
    
    my $user_options = get_user_options($uid);
    my $user_typed_options = hash_cut $user_options, @TYPED_OPTION_NAMES;
    delete $user_options->{$_} for @TYPED_OPTION_NAMES;

    set_user_typed_options($uid, $USER_OPTION_TYPE, $user_typed_options);
    set_user_options($uid, $user_options);
    
    $log->out("Finish processing uid: $uid");
}

$log->out('FINISH');

