#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '10 секунд',
  comment => 'Дообъединяем и доконвертируем размазанных по шардам rk-audit и pco-kmb. Скрипт можно перезапускать.',
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::HashUtils;

use Settings;
use ScriptHelper;
use ShardingTools qw(ppc_shards);

my @CLIDS = (
    393734
);

my $MAX_RESHARD_ITERATIONS = 60;

$log->out('START');

for my $primary_clid (@CLIDS) {
    my $primary_shard = get_shard(ClientID => $primary_clid);

    $log->die("unknown shard for $primary_clid") unless $primary_shard;

    my $msg_prefix_guard = $log->msg_prefix_guard("[ClientID $primary_clid]");

    $log->out("Fetching Direct data from non-primary (!= $primary_shard) shards");
    for my $secondary_shard (ppc_shards()) {
        next if $secondary_shard == $primary_shard;
        my $second_clients = get_all_sql(PPC(shard => $secondary_shard), ['
            SELECT u.uid, u.ClientID
            FROM users u
         ', WHERE => {
               'u.ClientID' => $primary_clid,
            },
        ]);
        if (@$second_clients) {
            $log->out('Got ' . scalar(@$second_clients) . ' non-primary representatives and clients: ', $second_clients);

            # Привозим главного клиента [только его можно нормально возить] в один шард с неглавным
            _reshard_client($primary_clid, $primary_shard, $secondary_shard);
        }

    }
}

$log->out('FINISH');


=head3 _reshard_client

    Решардит клиента в указанный шард

    _reshard_client($clid, $from_shard, $to_shard);

=cut

sub _reshard_client {
    my ($clid, $from_shard, $to_shard) = @_;

    my %TABLES_TO_CHECK = (
        client_domains => [qw(ClientID camp_type domain_id)],
        client_domains_stripped => [qw(ClientID domain_id)],
    );

    for my $table (sort keys %TABLES_TO_CHECK) {
        my $key = $TABLES_TO_CHECK{$table};
        $log->out("Checking for duplicate records in table $table");
        my $rows = get_all_sql(PPC(shard => $from_shard), ['SELECT * FROM', $table, WHERE => {ClientID => $clid}]);
        for my $row (@$rows) {
            my $key = hash_cut $row, @$key;
            my $to_row_exists = get_one_field_sql(PPC(shard => $to_shard), ['SELECT 1 FROM', $table, WHERE => $key, 'LIMIT 1']);
            if ($to_row_exists) {
                $log->out("Deleting duplicate row:", $row);
                do_delete_from_table(PPC(shard => $from_shard), $table, where => $key);
            }
        }
    }

    $log->out("Resharding $clid to shard $to_shard");
    my $reshard_id = do_insert_into_table(PPCDICT, 'reshard_queue', {
        ClientID => $clid,
        status => 'new',
        old_shard => $from_shard,
        new_shard => $to_shard,
        wanted_start_time__dont_quote => 'NOW()',
    });

    $log->out("Waiting for $clid resharding (id = $reshard_id)");
    my $is_reshard_done = 0;
    my $iters = 0;
    do {
        sleep 30;
        $is_reshard_done = get_one_field_sql(PPCDICT, ['
            SELECT 1
            FROM reshard_queue
         ', WHERE => {
                id => $reshard_id,
                ClientID => $clid,
                status => 'done',
            },
        ]);
        $iters++;
    } while (!$is_reshard_done && $iters < $MAX_RESHARD_ITERATIONS);

    if ($is_reshard_done) {
        $log->out("Resharing of $clid successed");
    } else {
        $log->die("Resharing of $clid failed");
    }
}
