#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => '9 минут (суммарно) на dev7 на всех шардах',
    comment => "Конвертируем правила (json) внутри условий нацеливания",
}

=cut

use Direct::Modern;

use my_inc '..';

use Settings;
use ScriptHelper;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;
use ShardingTools;

use Direct::Model::DynamicCondition;
use Direct::Model::DynamicCondition::Manager;

use Direct::DynamicConditions;

my $MAX_ITEM_GROUPS_TO_UPDATE = 100;

$log->out('START');

for my $shard (ppc_shards()) {
    my $adgroup_ids = get_one_column_sql(PPC(shard => $shard), "SELECT DISTINCT pid FROM dynamic_conditions");

    for my $adgroup_ids_chunk (chunks($adgroup_ids, $MAX_ITEM_GROUPS_TO_UPDATE)) {
        $log->out({"[shard: $shard] Updating dynamic conditions for adgroups: " => $adgroup_ids_chunk});

        do_in_transaction {
            my $dyn_conds = Direct::DynamicConditions->get_by(adgroup_id => $adgroup_ids_chunk, with_deleted => 1, for_update => 1)->items;

            for my $dyn_cond (@$dyn_conds) {
                if (scalar(grep { $_->type eq 'URL_prodlist' } @{$dyn_cond->condition}) > 1) {
                    # Нужно объединить несколько правил `URL_prodlist` в одно правило с несколькими аргументами
                    my (@rules, %url_prodlist);
                    for my $rule (@{$dyn_cond->condition}) {
                        if ($rule->type eq 'URL_prodlist' && $url_prodlist{$rule->kind}) {
                            push @{$url_prodlist{$rule->kind}->value}, @{$rule->value};
                            next;
                        }
                        $url_prodlist{$rule->kind} = $rule if $rule->type eq 'URL_prodlist';
                        push @rules, $rule;
                    }
                    $dyn_cond->condition(\@rules);
                } else {
                    # Данные внутри моделей уже смигрированы, просто пересохраним их
                    $dyn_cond->condition($dyn_cond->condition);
                }
            }

            # Найдем нарушения уникальности (pid + condition_hash) и поправим их
            my %dyn_conds_by_hash;
            push @{$dyn_conds_by_hash{ $_->adgroup_id }{ $_->_condition_hash }}, $_ for @$dyn_conds;
            while (my ($adgroup_id, $x) = each %dyn_conds_by_hash) {
                while (my ($hash, $nonuniq_dyn_conds) = each %$x) {
                    next if @$nonuniq_dyn_conds == 1;
                    croak "Found more than two non-uniq dynamic conditions" if @$nonuniq_dyn_conds > 2;
                    # Для одного из условий нацеливания модифицируем хеш (в приоритете удаленное условие)
                    my $dyn_cond = (sort { ($a->is_deleted ? 0 : 1) <=> ($b->is_deleted ? 0 : 1) } @$nonuniq_dyn_conds)[0];
                    $log->out(sprintf(
                        "[shard: $shard] Changing hash for non-unique %s dynamic condition #%s",
                        $dyn_cond->is_deleted ? "deleted" : "ACTIVE",
                        $dyn_cond->dyn_cond_id,
                    ));
                    $dyn_cond->_condition_hash($dyn_cond->_condition_hash + 20151127);
                }
            }

            # Обновим таблицу dynamic_conditions
            $_->id($_->dyn_cond_id) for @$dyn_conds; # Workaround: используем dyn_cond_id в качестве pkey
            Direct::Model::DynamicCondition::Manager->_update_one_table_in_db(
                PPC(shard => $shard),
                dynamic_conditions => 'dyn_cond_id',
                $dyn_conds,
            );
        };
    }
};

$log->out('FINISH');
