#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "20 мин",
  comment => "если будет тормозить ppclog, можно перезапустить с --sleep-coef=5"
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::Retry;
use Yandex::TimeCommon;

use Settings;
use ScriptHelper;

my $CHUNK_SIZE = 1000;

$log->out('START');
my $SLEEP_COEF = 2;
extract_script_params(
    "sleep-coef" => \$SLEEP_COEF,
    );

# чистим сегодняшний день, чтобы его нормально заполнил скрипт обновления logapi_users
my $today = today();
my $month = substr($today, 0, 6);
while(1) {
    my $_rg = relaxed_guard times => $SLEEP_COEF;
    my $max_client_uid = get_one_field_sql(PPCLOG, "
                            SELECT max(client_uid)
                              FROM (
                                   SELECT client_uid
                                     FROM logapi_users_$month
                                    WHERE date = ? 
                                    ORDER BY client_uid 
                                    LIMIT $CHUNK_SIZE
                                   ) t", $today);
    last unless defined $max_client_uid;
    my $deleted = do_delete_from_table(PPCLOG, "logapi_users_$month", where => {date => $today, client_uid__le => $max_client_uid});
    $log->out("deleted $deleted rows up to client_uid=$max_client_uid");
}

$log->out("set $today to property");
Property->new('ppcRefreshLogApiUsers_processed_time')->set($today);

$log->out('FINISH');

