#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "полтора-два часа",
}

=cut

use Direct::Modern;

use Yandex::ListUtils;
use Yandex::Shell;

use Settings;
use ScriptHelper;

my $script_path = my_inc::path('../protected/one-shot/fix-bs_order_target_stat-data.pl');
my $data_path = my_inc::path('./20151208_retry_refresh_quick_stat_for_converted_orders.data');

my %data_by_dates;

$log->out('START');

$log->out("load orders for refresh from file $data_path");
open (my $fh, '<', $data_path) or $log->die("Error opening file: $!");
my $cnt = 0;
while (my $line = <$fh>) {
    if ($line =~ m/^(\d+)\t(\d+)\t(\d+)$/) {
        my $date_key = join('__', $2, $3);
        push @{ $data_by_dates{$date_key} }, $1;
        $cnt++;
    } else {
        $log->out("invalid data line: $line");
    }
}
close ($fh) or $log->die("Error closing file: $!");

$log->out("Got $cnt orders to refresh");

for my $dates_pair (sort keys %data_by_dates) {
    my ($date_from, $date_to) = split(qr/__/, $dates_pair);
    for my $orders_chunk (chunks($data_by_dates{$dates_pair}, 100)) {
        $log->out({date_from => $date_from, date_to => $date_to, OrderID => $orders_chunk});
        my $ret = eval {
            yash_system($script_path, '--fix', '--order-chunk' => 20, '--from' => $date_from, '--to', $date_to, map { ('--orderid' => $_) } @$orders_chunk);
            return 1;
        };
        $log->out(!$ret || $@ ? 'ERROR' : 'OK');
    }
}

$log->out('FINISH');

