#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '2 минуты',
  comment => 'Исправляем дату конвертации для объединённых в Балансе клиентов',
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::Balance qw(balance_get_all_equal_clients);
use Yandex::DBShards;

use Settings;
use ScriptHelper;

$log->out('START');

$log->out('Fetching equal clients from Balance');
my $merged_clients = balance_get_all_equal_clients();
$log->out('Got ' . scalar(@$merged_clients) . ' merged client pairs');

my %clid2primary = map { $_->{CLIENT_ID} => $_->{CLASS_ID} } grep { $_->{CLIENT_ID} != $_->{CLASS_ID} } @$merged_clients;
foreach_shard ClientID => [keys %clid2primary], chunk_size => 1_000, sub {
    my ($shard, $clientids) = @_;

    # данные должны быть только на главном ClientID
    # с неглавных надо всё перевешивать
    $log->out('Fetching Direct data for non-primary clients:', $clientids);
    my $non_primary_ccqs = get_all_sql(PPC(shard => $shard), ['
        SELECT q.*
        FROM currency_convert_queue q
     ', WHERE => {
            'q.ClientID' => $clientids,
        },
    ]);
    $log->out('Got ' . scalar(@$non_primary_ccqs) . ' non-primary currency_convert_queue records');

    for my $non_primary_ccq (@$non_primary_ccqs) {
        my $non_primary_clid = $non_primary_ccq->{ClientID};
        my $primary_clid = $clid2primary{$non_primary_clid};

        $log->out("Merging $non_primary_clid => $primary_clid");

        my $is_duplicate = get_one_field_sql(PPC(shard => $shard), ['SELECT 1 FROM currency_convert_queue', WHERE => {ClientID => $primary_clid}, 'LIMIT 1']);
        if ($is_duplicate) {
            $log->out("Skipping duplicate record for ClientID $primary_clid");
        } else {
            $log->out({update => $non_primary_ccq});
            do_update_table(PPC(shard => $shard), 'currency_convert_queue', { ClientID => $primary_clid }, where => { ClientID => $non_primary_clid });
        }

    }
};

$log->out('FINISH');
