#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "20 минут",
  comment => "включает yclid для всех перфоманс кампаний и насыпает их на переотправку в БК в ленивую очередь"
}

=cut

use warnings;
use strict;
use utf8;

use BS::ResyncQueue;
use Yandex::DBTools;
use ShardingTools qw/ppc_shards/;

use Settings;
use ScriptHelper;


$log->out('START');

for my $shard (ppc_shards()) {
    $log->out("shard $shard");
    my $cids_for_enable_yclid = get_one_column_sql(PPC(shard => $shard),
                                                   ["SELECT c.cid FROM campaigns c
                                                     JOIN camp_options co on c.cid=co.cid",
                                                     WHERE => {
                                                       'c.type' => 'performance',
                                                       'co.status_click_track' => 0,
                                                     }]);
    $log->out("got ". scalar @$cids_for_enable_yclid ." campaigns for yclid enable: ". join(',', @$cids_for_enable_yclid));
    # status_click_track отдаётся в API, поэтому для апишных клиентов это изменение кампании и надо поменять campaigns.LastChange
    do_update_table(PPC(shard => $shard), 'campaigns c join camp_options co on c.cid=co.cid',
                                         {'c.LastChange__dont_quote' => 'NOW()', 'co.status_click_track' => 1},
                                           where => {'c.cid' => $cids_for_enable_yclid});
    $log->out('add campaigns to bs_resync');
    bs_resync_camps($cids_for_enable_yclid);
    $log->out('done');
}

$log->out('FINISH');
