#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => '20 минут (суммарно) на dev7 на всех шардах',
    comment => "Выставляем правильный ContextLimit для ДТО кампаний",
}

=cut

use Direct::Modern;

use my_inc '..';

use Settings;
use ScriptHelper;

use Yandex::DBTools;
use ShardingTools;

my $MAX_ITEMS_TO_UPDATE = 10_000;

$log->out('START');

for my $shard (ppc_shards()) {
    my ($next_start_cid, $max_cid) = get_one_line_array_sql(PPC(shard => $shard), 'SELECT min(cid), max(cid) FROM campaigns');

    while ($next_start_cid <= $max_cid) {
        do_sql(PPC(shard => $shard), q{
            UPDATE campaigns
            SET ContextLimit = 254, dontShowYacontext = "Yes", statusBsSynced = "No", LastChange = LastChange, ContextPriceCoef = 100
            WHERE cid >= ? AND cid < ? AND type = "dynamic"
        }, $next_start_cid, $next_start_cid + $MAX_ITEMS_TO_UPDATE);

        $log->out(sprintf("[shard $shard] Updating campaigns %d%%", int((($next_start_cid + $MAX_ITEMS_TO_UPDATE) / $max_cid) * 100)));

        $next_start_cid += $MAX_ITEMS_TO_UPDATE;
    }
};

$log->out('FINISH');
