#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => '2 секунды (суммарно) на devtest на всех шардах',
    comment => 'Чиним перфоманс фильтры дубль 2 (available = "true" вместо true в json)',
}

=cut

use Direct::Modern;

use my_inc '..';

use Settings;
use ScriptHelper;

use Yandex::DBTools;

use Direct::Model::PerformanceFilter;
use Direct::Model::PerformanceFilter::Manager;

use Direct::PerformanceFilters;

$log->out('START');

my $adgroup_ids = get_one_column_sql(PPC(shard => 'all'), "SELECT DISTINCT pid FROM bids_performance");
my $perf_filters = Direct::PerformanceFilters->get_by(adgroup_id => $adgroup_ids, with_deleted => 1)->items;

for my $perf_filter (@$perf_filters) {
    $perf_filter->condition($perf_filter->condition); # to re-serialize condition

    if ($perf_filter->is_changed) {
        if (!$perf_filter->is_deleted && !$perf_filter->is_suspended) {
            $perf_filter->do_bs_sync_banners(1);
            $perf_filter->do_bs_sync_adgroup(1);
        }

        $log->out({"Updating `condition_json` for performance filter `".$perf_filter->id."`" => $perf_filter->_condition_json});
    }
}

Direct::Model::PerformanceFilter::Manager->new(items => $perf_filters)->update();

$log->out('FINISH');
