#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
[
  {
    type => 'sql',
    webstop => 0,
    db => 'ppc:all',
    when => 'before',
    time_estimate => 'мгновенно',
    sql => '
CREATE TABLE `client_teaser_data_lastupdate` (
  `ClientID` int(10) unsigned NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ClientID`),
  KEY (last_update)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
    ',
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => '5 часов',
    comment => 'заполняем таблицу client_teaser_data_lastupdate',
  },
]

=cut

use Direct::Modern;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use ShardingTools;

my $CHUNK_SIZE = 10_000;

$log->out('START');

for my $shard (ppc_shards()) {
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard_$shard]");
    my $clients_fetched;
    my $min_clid = 0;
    do {
        $log->out("Fetching data to move starting with ClientID $min_clid");
        my $sth = exec_sql(PPC(shard => $shard), ['
            SELECT ClientID, MAX(last_update)
            FROM client_firm_country_currency
        ',  WHERE => {
                'ClientID__gt' => $min_clid,
        }, "
            GROUP BY ClientID
            ORDER BY ClientID
            LIMIT $CHUNK_SIZE
        "]);
        my $data = $sth->fetchall_arrayref();
        $clients_fetched = scalar @$data;
        $log->out("Got $clients_fetched:", $data);
        if ($clients_fetched > 0) {
            $min_clid = $data->[-1]->[0];
            do_mass_insert_sql(PPC(shard => $shard), 'INSERT IGNORE INTO client_teaser_data_lastupdate (ClientID, last_update) VALUES %s', $data);
        }
    } while ($clients_fetched > 0);
}

$log->out('FINISH');

