#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'полчаса-час',
  comment => 'снимаем тизеры у клиентов с кампаниями разных типов обслуживания',
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use Campaign::Types ();
use ShardingTools;

$log->out('START');

for my $shard (ppc_shards()) {
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard_$shard]");
    $log->out('Fetching clients to remove teaser');
    my $clids = get_one_column_sql(PPC(shard => $shard), ['
        SELECT ctfmt.ClientID
        FROM clients_to_force_multicurrency_teaser ctfmt
        LEFT JOIN currency_convert_queue q ON ctfmt.ClientID = q.ClientID
        LEFT JOIN clients cl ON ctfmt.ClientID = cl.ClientID
        INNER JOIN users u ON u.ClientID = ctfmt.ClientID
        INNER JOIN campaigns c ON u.uid = c.uid
        WHERE
            IFNULL(cl.work_currency, "YND_FIXED") = "YND_FIXED"
            AND q.ClientID IS NULL
            AND', {'c.type__not_in' => Campaign::Types::get_camp_kind_types('non_currency_convert')}, '
        GROUP BY ctfmt.ClientID
        HAVING COUNT(DISTINCT IFNULL(c.AgencyID,0), IF(c.ManagerUID > 0, 1, 0)) > 1
    ']);
    if (@$clids) {
        $log->out('Got ' . scalar(@$clids) . ' clients to remove teaser:', $clids);
        do_delete_from_table(PPC(shard => $shard), 'clients_to_force_multicurrency_teaser', where => {ClientID => $clids});
    } else {
        $log->out('Got no clients to remove teaser');
    }
}

$log->out('FINISH');
