#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1,5 часа",
  comment => "включает yclid для всех кампаний кроме исключений и насыпает их на переотправку в БК в ленивую очередь"
}

=cut

use warnings;
use strict;
use utf8;

use BS::ResyncQueue;
use List::MoreUtils qw/uniq/;
use RBAC2::Extended;
use RBACElementary;
use ShardingTools qw/ppc_shards/;
use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;

use Settings;
use ScriptHelper;

# список исключений из https://st.yandex-team.ru/DIRECT-41181 - не включаем yclid для этих uid-ов
my $exclusion_uids = [
    10094020,102071387,102525474,104700381,107482854,114788987,115821026,116591722,117479841,117745555,11975591,120723767,121358353,122193006,12459494,
    126094992,129069191,129409945,129458273,129756413,130595915,130869096,131642444,132486522,133292476,135311603,135475557,135772875,136312968,137346028,
    137388005,137585414,138623588,140591005,141703946,141980283,149680428,152553961,154643662,155649102,155850061,156051313,156394645,157005497,157070665,
    158627201,158805491,159126468,159225415,159424581,159491673,159508411,159664335,160188606,160666187,160800048,161914227,161972342,162073219,162904864,
    163484653,163542754,164297444,164856235,165452499,165646889,165909220,166211857,166820724,168133143,168836,172138332,172552672,173487751,173602738,
    173616806,173632250,17450321,175681513,17574846,175993988,176263512,176635860,179800772,180144537,180881055,181275349,18172303,181960465,181986938,
    183381553,183473302,184090215,184776226,185723216,18573,18584482,187173263,187627013,192131806,192502866,19281613,193375797,194691754,194705936,
    194721944,19487376,195888970,195930099,196791683,197599039,197646438,197706191,19796212,198205184,198515073,198823317,199162049,200202528,200558215,
    202143859,202830248,204365231,204398298,204654616,205171723,205307516,205584942,206770434,207728292,208783007,209128112,21237293,213561855,213743200,
    214470744,215269721,215462377,215967129,215972186,215972415,217068068,218317419,218877371,219219182,219570316,219613214,220198094,220665523,221497916,
    222136833,222518033,224584570,22485818,225008740,225196935,225557609,225647032,225740858,22657868,227023107,227135369,227832050,229153756,229190559,
    229579542,229597761,229984521,230071480,230183164,230286887,231384211,231510321,231653058,232609169,232624415,233071551,234038887,234887461,235546463,
    235654510,235660282,235833058,236308288,236725542,23687838,237184909,237189445,237418674,237594551,238264464,238968932,239671772,239674033,239999408,
    240126708,241465107,242073913,242190830,242334799,242336242,243284155,243516841,243908315,244059575,244355987,245019215,245909545,246051135,246331328,
    24666480,247319871,247783825,248094081,248198745,248270584,24833379,248542086,248648583,248668056,24866856,248812794,248902140,248925131,249601631,
    249721326,249826355,250196727,250295139,250306612,250306783,250524056,250661888,251194096,251803929,251818104,251889744,252682470,252984121,253055885,
    253645041,254396599,254417968,254611523,254728525,254751684,255208372,255234249,255320386,255947879,256710593,256800917,256944130,257609012,257778483,
    257908957,258091120,258091954,258451755,258529212,258569822,258576119,258625655,258741917,259019781,259351176,259809983,25981411,260083223,264714230,
    264725670,264855583,264988483,265109486,266235696,26668389,267386181,267509862,267637401,268096633,268137400,268339267,268452495,268456053,268887273,
    269201879,269632809,269763445,26982783,269828629,270482405,270558672,270760486,271056989,271108214,271211980,27172175,272338625,272460692,272965231,
    273190246,274083547,275143193,275144470,275726687,275735972,276281778,276751473,278499040,278673646,27972959,280281658,281013768,281228726,281465603,
    282528969,282545667,282656194,28295571,283325124,283443633,283455480,283610097,283977264,284430615,284545486,284849125,286198849,287239244,287611820,
    288393518,288729454,288931285,289477201,289480261,289647067,289784378,290176812,291009312,291410,291493940,291744468,292676800,292701976,292843092,
    292858190,293113735,293115892,293309590,293859790,293881970,294021206,294030676,296255127,296938285,297076095,299252208,299412798,29941508,299418658,
    300063466,30016126,300803456,300858682,301448271,301738900,302346258,302496483,302506488,302957806,303038050,304060526,304081131,304172927,304197873,
    304198864,304869593,305060899,305632590,305656259,305744205,305895182,306184835,306769696,306782334,306898408,307066444,307125377,307787625,308067197,
    308096230,308138080,308763198,308771026,308936317,308936936,309083421,309120698,309122565,309162923,309873127,310026961,310124674,310165139,310515243,
    310549967,310664055,310669152,310796981,310813413,311470080,311751524,311864951,312052467,312395318,312442980,312901707,312929338,312932376,312957357,
    313107397,313435448,313537052,313612951,313634050,313757184,313781412,313958707,313962949,314061248,314082766,314434885,314509246,314552222,314780567,
    314801855,314807371,314899157,314918156,314930199,314931060,314962983,315043091,315048315,315070906,315164108,315566780,315590388,315695814,315727937,
    315854559,315864153,316409230,316522135,316522602,316527134,316786736,317215417,317290626,317404023,317411846,317585232,317585505,317651790,318043168,
    318233519,318551015,318571165,318923032,319086806,319104089,319217792,319569127,320422972,32064999,33166880,34066910,3420385,37421620,40852810,41005211,
    41136570,43818030,45419361,4655316,47736779,49098460,49100195,4953549,50867162,51136782,52230785,53415196,53751885,62660547,6655560,67978431,67987288,
    69062305,73280339,75468548,77974347,78534055,78602225,79037866,79085000,79573565,80076766,80454067,80823559,81978305,82778628,83265174,83923490,84468254,
    86659109,86702143,87629975,87751909,87883940,89386123,9035897,91821259,92226133,93239872,94098346,9411123,95762013,96160239,97059467,9823829,98566863,
    181456081
];

my $OPERATOR_UID = 1;
my $CHUNK_SIZE = 5000;

$log->out('START');

$log->out('Connection to RBAC');
my $rbac = eval { RBAC2::Extended->get_singleton($OPERATOR_UID) } or $log->die("Can't connect to RBAC: $@");
my $exclusion_agency_ids = [ uniq values %{rbac_get_agencies_clientids_by_uids( $exclusion_uids)} ];

for my $shard (ppc_shards()) {
    $log->out("shard $shard");
    my $cids_for_enable_yclid = get_one_column_sql(PPC(shard => $shard),
                                                   ["SELECT c.cid FROM campaigns c
                                                     LEFT JOIN camp_options co on c.cid=co.cid",
                                                     WHERE => {
                                                       'c.uid__not_in' => $exclusion_uids,
                                                       'c.AgencyID__not_in' => $exclusion_agency_ids,
                                                       _TEXT => 'IFNULL(co.status_click_track, 0) = 0',
                                                     }]);
    $log->out("got ". scalar @$cids_for_enable_yclid ." campaigns for yclid enable");
    $log->out({cids_for_enable_yclid => $cids_for_enable_yclid});
    for my $cids_chunk (chunks($cids_for_enable_yclid, $CHUNK_SIZE)) {
        my $data = [map { [$_, 1] } @$cids_chunk];
        do_in_transaction {
            do_mass_insert_sql(PPC(shard => $shard), 'INSERT INTO camp_options (cid, status_click_track)
                                                      VALUES %s
                                                      ON DUPLICATE KEY UPDATE status_click_track = VALUES(status_click_track)', $data);
            # status_click_track отдаётся в API, поэтому для апишных клиентов это изменение кампании и надо поменять campaigns.LastChange
            do_update_table(PPC(shard => $shard), 'campaigns', {'LastChange__dont_quote' => 'NOW()'}, where => {'cid' => $cids_chunk});
        };
        $log->out({bs_resync_chunk => $cids_chunk});
        bs_resync_camps($cids_chunk);
    }
    $log->out('done');
}

$log->out('FINISH');
