#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => '70 минут (суммарно) на devtest на всех шардах',
    comment => 'Заполняем поле pid в warnplace таблице.',
}

=cut

use Direct::Modern;

use my_inc '..';

use Settings;
use ScriptHelper;
use ShardingTools;
use PrimitivesIds;

use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::Retry qw/relaxed/;

my $SLEEP_COEF = 0.1;
extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
);

$log->out('START');

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;
    my $bids = get_one_column_sql(PPC(shard=>$shard), "SELECT bid FROM warnplace where pid=0");
    $log->out("got all bids");
    for my $chunk (chunks($bids, 1_000)) {
        relaxed times => $SLEEP_COEF, sub {
            my $pids = get_bid2pid(bid => $chunk);
            $log->out("got all pids for chunk");
            my $affected_rows = 0;
            $affected_rows = do_mass_update_sql(PPC(shard=>$shard), "warnplace", "bid", {map {$_ => {pid => $pids->{$_}}} keys %$pids}) if %$pids;
            $log->out(sprintf("affected %d rows", $affected_rows));
        }
    }
});

$log->out('FINISH');
