#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'минута',
  comment => 'переотправляем в Модерацию команды, которые отправили без номера кампании
Запускать по отмашке pankovpv@
Перед запуском выполнить scp root@ppcdev2:/tmp/20160114_resend-moderation-commands-without-cid.data /tmp/20160114_resend-moderation-commands-without-cid.data',
}

=head2 .data

    Файл с командами для восстановления строился так:
    egrep -h -A 1 'processMagicQueue: sending [0-9]+ items' /mnt/remote-log-rfs/ppcscripts*/protected/moderateClientNew.*.log.2016011{3,4} | egrep -v 'processMagicQueue: sending [0-9]+ items' | perl -MJSON -Mutf8 -MList::MoreUtils=any -wlne 'next if $_ eq "--"; my @rows_for_insert; my @x = split /\s/, $_, 5; my ($shard, $data); if($x[3] =~ /^shard_(\d+)$/) {$shard = $1;} else {die}; $data = from_json($x[4]); for my $row (@$data) { if ((any { $_ eq $row->{cmd} } qw(AddDocument deleteBanner deleteAdGroup deleteImages deleteContactInfo deleteSitelinksSet)) && !exists $row->{data}->{cid}) { $row->{data}->{cid} = $row->{cid}; $row->{shard} = $shard; print to_json($row); } }' > /tmp/20160114_resend-moderation-commands-without-cid.data

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw(nsort);

use JSON;

use Settings;
use ScriptHelper;

my $data_path = '/tmp/20160114_resend-moderation-commands-without-cid.data';

$log->out('START');

my %shard2data;

$log->out('Parsing file');
open(my $f, '<:encoding(UTF-8)', $data_path) || $log->die("Cannot open $data_path: $!");
while (my $line_json = <$f>) {
    my $line = from_json($line_json);
    my $shard = $line->{shard};
    push @{ $shard2data{$shard} }, [
        $line->{cmd},
        to_json($line->{data}),
        $line->{logtime},
        $line->{cid},
    ];
}
close($f) || $log->die("Cannot close $data_path: $!");

$log->out('Inserting data');
for my $shard (nsort keys %shard2data) {
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard_$shard]");
    my $data_for_insert = $shard2data{$shard};
    $log->out('Inserting commands:', $data_for_insert);
    do_mass_insert_sql(PPC(shard => $shard), "INSERT INTO moderation_cmd_queue (cmd, data, logtime, cid) VALUES %s", $data_for_insert);
}

$log->out('FINISH');
