#!/usr/bin/perl

=head1

    https://st.yandex-team.ru/DIRECT-47331
    https://st.yandex-team.ru/DIRECT-49846

    По всем кампаниям из списка биллинга проверили наличие в PPC, если там не нашли, то считаем удаленной и обновляем эту кампанию в биллинге (без менеджера)

Список кампаний:
    https://st.yandex-team.ru/PAYSUP-222669

=cut

use my_inc '..';

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => 'несколько часов',
    comment => 'перед запуском нужно скопировать файл с кампаниями:
        scp ppcdev1.yandex.ru:/var/www/beta.msa.8084/export_direct_2_deleted.csv /tmp/export_direct_2_deleted.csv
    ',
}

=cut

use Direct::Modern;

use Text::CSV;
use Yandex::DBTools;
use Yandex::Balance;
use Yandex::ListUtils qw/chunks/;
use Settings;
use ScriptHelper;

our $UID = 1; # operator

sub main {
    $log->out('START');

    my %camps;
    my $csv = Text::CSV->new ({binary => 1}) or $log->die("Cannot use CSV: " . Text::CSV->error_diag());
    # open my $fh, "<", "export_direct_1.csv" or die "open export_direct_1.csv: $!"; # only on beta
    open my $fh, "<", "/tmp/export_direct_2_deleted.csv" or $log->die("open /tmp/export_direct_2_deleted.csv: $!"); # only on prod

    my $i = 0;
    while (my $line = $csv->getline($fh)) {
        # next if $i++ == 0; # skip header / only on beta
        my ($service_order_id, $ClientID, $ProductID) = @$line;
        my ($ServiceID, $cid) = $service_order_id =~ /^(\d+)-(\d+)$/;
        $log->die({"Failied parse cvs line" => $line}) unless $ServiceID && $cid && $ProductID && $ClientID;

        $camps{$cid} = {
            ServiceID => $ServiceID,
            ProductID => $ProductID,
            ClientID => $ClientID,
        };
    }
    close $fh;

    # для фильтрации на бете нужно переключить конфигурацию на продакшен: mk conf-roprod
    # open my $fh_out, ">", "export_direct_2_deleted.csv" or die "open export_direct_2_deleted.csv: $!";
    for my $cids_chunk (chunks([keys %camps], 1000)) {
        # по наличию кампании в базе определяем её удаленность
        my $exists_cids = get_hash_sql(PPC(shard => "all"), ["select cid, 1 from campaigns", where => {cid => $cids_chunk}]);
        my @deleted_cids = grep {! defined $exists_cids->{$_}} @$cids_chunk;

        # ветку запускаем на бете, для отфильтровывания удаленных кампаний (в продакшен базе)
        if (0) {
            for my $cid (@deleted_cids) {
                # printf $fh_out qq/"%s-%s",%s,%s\n/, $camps{$cid}->{ServiceID}, $cid, $camps{$cid}->{ClientID}, $camps{$cid}->{ProductID};
            }
        }

        # ветку запускаем в деплое, only on prod
        if (@deleted_cids) {
            for my $cid (@deleted_cids) {
                # по одному, чтобы в логах осталась ошибка по каждому заказу
                my $balance_order = [
                    {
                        ServiceID => $camps{$cid}->{ServiceID},
                        ProductID => $camps{$cid}->{ProductID},
                        ServiceOrderID => $cid,
                        ClientID => $camps{$cid}->{ClientID},
                        NDS => 1,
                        Text => "deleted campaign",
                        unmoderated => 1,
                        AgencyID => 0,
                        ManagerUID => 0,
                    }
                ];

                my $balance_res = balance_create_update_orders($UID, $balance_order);
                $log->out({unservice_cid => $cid, balance_response => $balance_res ? "ok" : "error"});
            }
        }
    }
    # close $fh_out; # only on beta
    $log->out('FINISH');
}

main();