#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => '3 часа на devtest на всех шардах',
    comment => 'поправляем значение поля banners.statusPostModerate',
}

=cut

use Direct::Modern;

use my_inc '..';

use Settings;
use ScriptHelper;
use ShardingTools;

use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::Retry qw/relaxed/;

my $SLEEP_COEF = 0.5;
extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
);

$log->out('START');

for my $shard (ppc_shards()) {
    my $guard = $log->msg_prefix_guard("[shard_$shard]");
    $log->out("selecting problematic banners");
    my $bids = get_one_column_sql(PPC_HEAVY(shard => $shard), "SELECT bid FROM banners where statusModerate = 'Yes' and statusPostModerate = 'No'");
    $log->out(sprintf("got %s bids", scalar(@$bids)));
    for my $chunk (chunks($bids, 1_000)) {
        relaxed times => $SLEEP_COEF, sub {
            $log->out("updating next banners chunk");
            my $affected_rows = do_update_table(PPC(shard => $shard), "banners", 
                                                                      {statusPostModerate => 'Yes',
                                                                       statusBsSynced => 'No'}, 
                                                                      where => {bid => $chunk, statusModerate => 'Yes', statusPostModerate => 'No'});
            $log->out(sprintf("affected %d rows", $affected_rows+0));
        };
    }
}

$log->out('FINISH');
