#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "15 минут",
  comment => "Заменяет значения -1 на 100 в поле broad_match_limit таблицы ppc.camp_options"
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks nsort/;

use my_inc '..';

use ScriptHelper;
use Settings;

use ShardingTools qw/ppc_shards/;
use BS::ResyncQueue;


$log->out('START');

foreach my $shard (ppc_shards()) {
    $log->msg_prefix("[shard $shard] ");
    my $cids = get_one_column_sql(PPC(shard => $shard), "SELECT cid FROM camp_options WHERE broad_match_limit = -1");
    if (@$cids) {
        $log->out('Got '. scalar @$cids .' campaigns for update broad_match_limit:');
        $log->out({cids => $cids});
        foreach my $cid_chunk (chunks([nsort @$cids], 1000)) {
            do_update_table(PPC(shard => $shard), 'campaigns c join camp_options co on c.cid=co.cid',
                                    {
                                        'co.broad_match_limit' => 100,
                                        'c.LastChange__dont_quote' => 'NOW()',
                                    },
                                    where => {
                                        'c.cid' => $cid_chunk,
                                        'co.broad_match_limit' => -1,
                                    });
            $log->out('add campaigns chunk to bs_resync');
            bs_resync_camps($cid_chunk);
        }
    } else {
        $log->out("No campaigns for update broad_match_limit");
    }
    $log->out("Done");
}

$log->out('FINISH');

