#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => '3 часа на devtest на всех шардах',
    comment => 'поправляем значение поля bids_retargetings.price_context',
}

=cut

use Direct::Modern;

use my_inc '..';

use Settings;
use ScriptHelper;
use ShardingTools;

use Yandex::DBTools;
use Yandex::Retry qw/relaxed/;

use Currencies;

my $SLEEP_COEF = 0.5;
my $STEP = 10_000;

extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
);

$log->out('START');

my %min_prices = map { $_ => get_currency_constant($_, 'MIN_PRICE') } Currencies::get_currencies_list();
my %max_prices = map { $_ => get_currency_constant($_, 'MAX_PRICE') } Currencies::get_currencies_list();
my $min_price_sql_case = sql_case('c.currency', \%min_prices, default => get_currency_constant('YND_FIXED', 'MIN_PRICE'), dont_quote_value => 1);
my $max_price_sql_case = sql_case('c.currency', \%max_prices, default => get_currency_constant('YND_FIXED', 'MAX_PRICE'), dont_quote_value => 1);

for my $shard (ppc_shards()) {
    my $guard = $log->msg_prefix_guard("[shard_$shard]");
    $log->out("Selecting zero price_context retargetings");

    my ($next_ret_id, $max_ret_id) = get_one_line_array_sql(PPC(shard => $shard), "SELECT MIN(ret_id), MAX(ret_id) FROM bids_retargeting");
    while ($next_ret_id <= $max_ret_id) {
        my $bids_ret = get_all_sql(PPC_HEAVY(shard => $shard), "
            SELECT br.ret_id, br.price_context, c.currency
            FROM bids_retargeting br
            JOIN phrases g ON (g.pid = br.pid)
            JOIN campaigns c ON (c.cid = g.cid)
            WHERE
                br.ret_id >= $next_ret_id AND br.ret_id < @{[$next_ret_id + $STEP]} AND
                c.archived = 'No' AND c.autobudget = 'No' AND
                (br.price_context < $min_price_sql_case OR br.price_context > $max_price_sql_case)
        ");
        $next_ret_id += $STEP;

        next if !@$bids_ret;

        relaxed times => $SLEEP_COEF, sub {
            $log->out({"Updating next retargetings" => $bids_ret});

            do_sql(PPC(shard => $shard), ["
                UPDATE bids_retargeting br
                JOIN phrases g ON (g.pid = br.pid)
                JOIN campaigns c ON (c.cid = g.cid)
                SET br.price_context = LEAST(GREATEST(br.price_context, $min_price_sql_case), $max_price_sql_case)
            ", WHERE => {
                'br.ret_id' => [map { $_->{ret_id} } @$bids_ret],
            }]);
        };
    }
}

$log->out('FINISH');
