#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => 'около 5 часов',
    comment => '
        1. скопировать на машину файл ppcdev2:/home/zhur/campaigns.2016-03-03
        2. запустить деплой ./deploy/20160306_restore_statusBehavior.pl %path_to_campaigns.2016-03-03%
    ',
}

=cut

use Direct::Modern;

use my_inc '..';

use Settings;
use ScriptHelper;

use Yandex::DBTools;
use Yandex::DBShards;
use BS::ResyncQueue qw/bs_resync_camps/;
use File::Slurp qw/read_file/;

$log->out('START');

my (%behavior, %opts, @cids, $total_cids, $total_restore);
$total_restore = 0;
$total_cids = 0;
for my $line (read_file($ARGV[0])) {
    chomp $line;
    my ($cid, $statusBehavior, $opts) = split /\s+/, $line;
    $behavior{$cid} = $statusBehavior;
    $opts{$cid} = [grep { $_ eq 'enable_cpc_hold' } split ',', $opts || ''];
    push @cids, $cid;
    $total_cids++;

    $log->out(sprintf "read %d quantity of campaigns", $total_cids) if $total_cids % 10_000 == 0;

    if (@cids == 300_000) {
        restore_camps(\%behavior, \%opts, \@cids);
        @cids = ();
        %behavior = ();
        %opts = ();
    }
}

restore_camps(\%behavior, \%opts, \@cids);

$log->out(sprintf "total restored campaigns %d", $total_restore);

$log->out('FINISH');

sub restore_camps {

    my ($behavior, $opts, $cids) = @_; 

    my $camps = get_all_sql(PPC(cid => $cids), ["SELECT cid, statusBehavior, opts FROM campaigns", WHERE => {cid => SHARD_IDS}]);
    my (%behavior_case, %opts_case);
    for my $camp (@$camps) {
        my $cid = $camp->{cid};
        my $enable_cpc_hold = scalar grep { $_ eq 'enable_cpc_hold' } split ',', $camp->{opts} || '';
        if ($camp->{statusBehavior} ne $behavior->{$cid} 
            || $enable_cpc_hold != scalar @{$opts->{$cid}}) {

            $behavior_case{$cid} = $behavior->{$cid};
            my @other_opts = grep { $_ ne 'enable_cpc_hold' } split ',', $camp->{opts};
            $opts_case{$cid} = join ',', sort @other_opts, @{$opts->{$cid}};
            $log->out(sprintf "cid %d set statusBehavior == %s, opts == %s", $cid, $behavior{$cid}, $opts_case{$cid});
            $total_restore++;
        } 
    }

    if (scalar keys %behavior_case) {
        foreach_shard cid => [keys %behavior_case], sub {
            my ($shard, $cids) = @_;
            do_update_table(PPC(shard => $shard), "campaigns", {
                statusBehavior__dont_quote => sql_case(cid => { map { $_ => $behavior_case{$_} } @$cids },  default__dont_quote => 'statusBehavior'),
                opts__dont_quote => sql_case(cid => { map { $_ => $opts_case{$_} } @$cids }, default__dont_quote => 'opts'),
                LastChange__dont_quote => 'NOW()', 
            }, where => {cid => $cids});
            bs_resync_camps($cids, priority => 90);
        }
    } else {
        $log->out("the aren't campaigns for restore");
    }
}
