#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr

    [
        {
            type => 'sql',
            webstop => '0',
            db => 'ppc:all',
            when => 'before',
            time_estimate => 'предположительно 5-10 минут на первом шарде, по 3-4 минуты на остальных',
            comment => '
Предлагается запускать через direct-pt-osc + параллельно включить убивалку "лишних" запросов (direct-query-killer)
algorithm=inplace не получится использовать, т.к. в таблице есть поле timestamp (logtime), 
а таблица не альтерилась с перехода на mysql 5.6, так что альтер заодно перестроит timestamp.
',
            sql => 'alter table addresses modify column `precision` enum("exact","number","near","street","other","range") DEFAULT "other"',
        },
        {
            type => 'script',
            when => 'after',
            time_estimate => 'примерно 600 секунд',
            comment => "Поставляем значение 'range' в `addresses`.`precision` для тех строк, где значение этой колонки равно '' (пустой строке); ставим затронутые баннеры в очередь на ленивую переотправку",
        }
    ]

=cut

use Direct::Modern;

use my_inc '..';

use BS::ResyncQueue;

use Settings;
use ScriptHelper;
use ShardingTools;

use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::Retry qw/relaxed/;

my $PRIORITY   = -22;
my $SLEEP_COEF = 1;

extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
);

$log->out('START');
for my $shard ( ppc_shards() ) {

    my $guard = $log->msg_prefix_guard("[shard_$shard]");

    my $sth = exec_sql( PPC_HEAVY(shard => $shard), q/SELECT aid, ahash FROM addresses where `precision` = ""/ );
    while ( my ($aid, $ahash) = $sth->fetchrow_array ) {
        relaxed times => $SLEEP_COEF, sub {
            my $updated = do_update_table( PPC(shard => $shard), 'addresses', {precision => 'range'}, where => {aid => $aid, ahash => $ahash, precision => ''} );
            if ($updated + 0) {
                my $banners_to_resync = get_all_sql( PPC(shard => $shard), [
                        'SELECT c.cid, b.bid FROM campaigns c join banners b using (cid) join vcards using (vcard_id)',
                        WHERE => {
                            address_id       => $aid,
                            'b.BannerID__gt' => 0,
                            'c.statusShow'   => 'Yes',
                            'c.archived'     => 'No',
                        },
                    ]
                );

                if (@$banners_to_resync) {
                    $_->{priority} = $PRIORITY for @$banners_to_resync;
                    bs_resync($banners_to_resync);

                    $log->out("updated address #$aid, ahash #$ahash: set precision = 'range'");
                    $log->out('banners to resync: '. join(', ', map {$_->{bid}} @$banners_to_resync)) if @$banners_to_resync;
                }
            } else {
                $log->out("fail to updated address #$aid, ahash #$ahash: seems that address changed");
            }
        };
    }
    $sth->finish();

}
$log->out('FINISH');
