#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "30 секунд",
  comment => "Включаем принятые медийные баннеры, остановленные при переотправке через ленивую очередь"
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use ScriptHelper;
use Settings;

my @mbids = (qw/
    290 291 506 689 955 1101 1562 2009 2021 2286 2323 2328 2404 2485 2523 2527 2609 2777 2862 3052 3198 3318 3574 3625 3627 3886
    3887 3972 3984 4016 4017 4137 4140 4192 4290 4356 4535 4603 4930 5311 5322 5393 5425 5450 5460 5463 5544 5643 5711 5739 5823
    5985 6192 6193 6356 6357 6423 6424 6466 6496 6674 6727 6728 6736 6737 7268 7608 7782 7811 7814 8734 10428 11725 24699 24738
    401507 401531 401543 401731 401744 6757 36291 360739 366435 369627 370229 375705 375707 377168 377170 377171 377172 377173
    377174 377175 377177 377178 377179 377180 377181 377182 378239 378735 378846 379956 380151 380883 381226 381240 381326 381327
    383654 385105 385247 386154 386225 386226 387511 387512 390216 390480 401623 401624 401626 6994 7956 24174 47054 47055 47497
    47510 50487 355931 355944 355952 355954 356213 363011 365219 366011 367601 369257 370386 370570 371055 373137 373583 374004
    374465 375088 375089 376255 377814 378232 378607 378874 379160 379608 379611 379879 379880 380577 380608 381968 382063 382455
    382468 382469 382470 382698 382701 382857 383047 383420 383529 384309 385146 385531 385648 385675 386396 386493 386494 386495
    386496 386867 386868 386869 386870 386879 387164 399469 400423 401333 401437 401675 401676 401679 401683 401686 11214 18397
    18398 26666 36948 36949 39313 39314 41953 354095 354667 367869 367901 371901 372237 374350 374352 374487 374540 379976 380127
    380258 380279 380409 381325 383577 383599 383737 383999 384328 384696 385082 385085 385257 385259 385291 385292 385310 385391
    385683 386001 386312 386338 387339 387472 387559 387567 387568 387771 388379 388632 389105 390077 395898 397552 398583 399557
    401372 17039 17040 21098 21099 21100 21101 21102 21103 36918 38583 47142 49811 52450 53276 355760 355805 355808 355903 356198
    356289 356320 360088 361225 361595 361800 367445 367924 368556 369986 370027 370028 372171 374508 374772 375350 376006 377686
    380235 381148 381149 383659 383660 394323 399887 400469 401378 401650 34246 35911 35988 358383 362996 367728 367729 373247
    375356 376215 376277 377215 377270 381530 382851 382853 390593 391709 392649 393815 394747 395242 398047 399989 399990 400949
    401391 401528 401544 401625 401628 401629 35758 36230 398635 398816 398817 399426 399427 399428 399429 401036 401038 401380
    401510 401762 401763 9210 10299 13021 45281 49027 50041 399365 400675 401160 401302 401305 401326 401393 401395 401398 401410
    401419 401446 401455 401514 401738 401742
/);

$log->out('START');

foreach_shard mbid => \@mbids, with_undef_shard => 1, sub {
    my ($shard, $mbids_chunk) = @_;
    if ($shard) {
        $log->msg_prefix("[shard_$shard]");
        $log->out({mbids_chunk => $mbids_chunk});
        my $res = do_update_table(PPC(shard => $shard),
                        'media_banners b',
                        {
                            'b.statusShow' => 'Yes',
                            'b.statusBsSynced' => 'No',
                        },
                        where => { 'b.mbid' => $mbids_chunk, statusShow => 'No' });
        $log->out("banners updated, affected $res rows");
    } else {
        $log->msg_prefix(undef);
        $log->out({ERROR_bids_without_shard => $mbids_chunk});
    }
};

$log->out('FINISH');

