#!/usr/bin/perl

=head1 DEPLOY

# approved by hmepas
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "3 минуты на devtest",
  comment => "Заменяет значения NULL на '0#6#00#00#00#00' в поле worktime таблицы ppc.vcards"
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

use ShardingTools qw/ppc_shards/;
use BS::ResyncQueue;

$log->out('START');

foreach my $shard (ppc_shards()) {
    $log->msg_prefix("[shard $shard] ");
    # выбираем все визитки сразу, т.к. их не более 250
    my $vcard_ids = get_one_column_sql(PPC(shard => $shard), "SELECT vcard_id FROM vcards WHERE worktime IS NULL");
    if (@$vcard_ids) {
        $log->out('got '. scalar @$vcard_ids .' vcards for update worktime:');
        $log->out({vcard_ids => $vcard_ids});

        # выбираем все объявления сразу, т.к. их не более 550
        my $banners = get_all_sql(PPC(shard => $shard), ["SELECT cid, bid, -20 AS priority FROM banners", WHERE => { vcard_id => $vcard_ids }]);

        do_in_transaction {
            my $update_result = do_update_table(PPC(shard => $shard), 'vcards', { worktime => '0#6#00#00#00#00' }, where => { vcard_id => $vcard_ids, worktime__is_null => 1 });
            if (($update_result + 0) && @$banners) {
                bs_resync($banners);
            }
        };
        $log->out('updated worktime to "0#6#00#00#00#00"');
        if (@$banners) {
            $log->out('sent '.(scalar @$banners).' banners to bs_resync:');
            $log->out({bids => [ map { $_->{bid} } @$banners ]});
        } else {
            $log->out('no banners linked with vcards');
        }
    } else {
        $log->out("no vcards with NULL in worktime field");
    }
    $log->out("Done");
}

$log->out('FINISH');

