#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "30 секунд",
  comment => "Сбрасываем флаг остановки для оставшихся в очереди медийных баннеров"
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use ScriptHelper;
use Settings;

my @mbids = (qw/
    289 2576 7963 8010 8162 8169 8237 8410 8463 8537 8783 8845 8848 8860 8861 8862 8890 9020 9071 9133 9199 9261 9345 9390
    9391 9673 9722 9723 9922 9935 9961 9963 10048 10192 10421 10468 10492 10493 10494 10511 10512 10513 10520 10521 10653
    10734 10786 10787 10873 10879 10902 10951 10969 10970 11020 11047 11079 11080 11254 11287 11581 11668 11903 11943 11944
    12020 12134 12294 12295 12322 12446 12449 12535 12592 12726 12781 12782 12788 12832 12945 12997 13139 13140 13221 13549
    13550 13650 13669 13755 13759 13790 13871 13872 13946 14026 14032 14121 14130 14247 14315 14410 14431 14474 14553 14563
    14724 14817 15003 15013 15015 15026 15077 15090 15125 15154 15163 15181 15182 15349 15471 15484 15832 15989 16155 16164
    16208 16312 16603 16757 16758 16827 16828 16833 16834 16927 16949 16954 16955 16956 17138 17158 17197 17213 17410 17431
    17437 17441 17573 17633 17680 17897 17901 17961 17972 18030 18031 18032 18033 18048 18242 18339 18407 18408 18616 18766
    18773 18815 18816 18957 18991 19031 19044 19221 19311 19319 19352 19369 19373 19502 19558 19559 19640 19641 19792 19849
    19852 19987 20005 20032 20084 20168 20189 20191 20192 20315 20365 20366 20413 20418 20437 20473 20480 20481 20482 20489
    20512 20513 20602 20742 20743 20803 20806 20810 20897 21068 21148 21178 21180 21269 21336 21426 21428 21513 21558 21612
    21613 21839 21850 21924 21927 21928 21938 21939 21941 21955 21957 22021 22249 22349 22406 22534 22535 22624 22711 22736
    22768 22833 22844 22958 23000 23019 23022 23026 23057 23071 23085 23192 23262 23275 23496 23650 23707 23732 23739 23785
    23847 23861 23940 23967 24110 24124 24136 24421 24498 24597 24765 24766 24816 24826 24845 25099 25105 25172 25280 25405
    25582 25649 25685 25699 25923 25925 26121 26137 26275 26282 26287 26474 26509 26513 26619 26756 26824 26961 26962 27012
    27118 27196 27232 27251 27252 27257 27265 27276 27338 27473 27474 27596 27622 27624 27966 27991 27992 27996 27997 28084
    28085 28107 28108 28110 28111 28225 28243 28309 28639 28734 28735 28737 28800 29043 29170 29212 29213 29463 29648 29792
    29800 29904 29955 29956 30161 30331 30332 30615 30702 30946 31524 31571 31598 31755 31769 31807 31924 32131 32132 32133
    32134 32269 32453 32471 32472 32529 32584 32637 32672 32958 33114 33240 33295 33385 34055 34078 34509 34510 34797 35049
    35050 35289 35409 35566 36168 36249 36355 36467 36482 36512 36513 36776 36791 36793 36842 36865 37045 37052 37163 37266
    37356 37681 37682 37683 37744 37755 37765 37817 37842 38276 38367 38388 38390 38461 38555 38731 38960 38979 39039 39147
    39180 39181 39209 39210 39246 39265 39272 39273 39288 39300 39400 39490 39495 39500 39583 39626 39638 39698 39748 39758
    39784 39797 39821 39822 39846 39882 39883 39931 39983 40068 40243 40244 40326 40361 40588 40637 40666 40667 40697 40787
    40804 40829 41210 41316 41367 41368 41369 41393 41478 41674 41888 41967 41968 42099 42286 42356 42773 42869 43005 43053
    43111 43113 43271 43272 43357 43567 43568 43634 43859 43978 43979 44011 44090 44115 44116 44117 44181 44275 44276 44277
    44406 44585 44586 44587 44628 44948 44950 44952 45124 45217 45324 45345 45346 45347 45349 45511 45512 45527 45528 45916
    45920 45979 46039 46098 46099 46428 46748 46757 46808 47044 47045 47097 47108 47379 47476 47477 47478 47479 47480 47481
    47482 47483 47587 47597 47598 47757 47804 47846 48033 48187 48249 48253 48446 48447 48567 48574 48801 48802 48839 48840
    48987 49081 49182 49183 49310 49311 49508 49529 49548 49567 49578 49594 49664 49737 49739 49741 49810 49856 49984 49996
    50055 50291 50395 50434 50438 50476 50477 50482 50586 50806 50808 51255 51318 51414 51425 51505 51621 51641 51900 51901
    51946 52024 52034 52112 52113 52137 52234 52352 52429 52436 52542 52568 52712 52792 52793 52794 52795 52943 52950 53096
    53160 53177 53178 53194 53213 53326 53416 353498 353534 353558 353616 353690 353715 353919 353965 353973 353974 354088
    354102 354236 354498 354500 354501 354505 354566 354606 354675 354687 354688 354689 354737 354748 354761 354816 354834
    354891 354964 354992 355038 355086 355128 355181 355236 355238 355299 355331 355514 355667 355765 355969 355970 355971
    355996 356214 356242 356337 356455 356507 356615 356617 356620 356699 356728 356745 356785 356831 356940 357093 357107
    357364 357417 357421 357611 357692 357970 358013 358080 358137 358154 358189 358219 358351 358377 358474 358529 358586
    358603 358638 358759 358764 358767 358768 358847 358858 358964 359000 359029 359038 359043 359087 359192 359225 359287
    359322 359323 359345 359348 359396 359415 359434 359545 359585 359625 359777 359778 359779 359781 359834 359954 359960
    359968 359969 359970 360062 360252 360283 360410 360757 360759 360818 360914 360932 361022 361108 361191 361311 361377
    361449 361450 361451 361452 361536 361540 361599 361713 361714 361728 362144 362167 362206 362207 362208 362209 362212
    362239 362240 362241 362764 362770 362817 362935 363030 363177 363429 363448 363482 363524 363539 363540 363543 363580
    363602 363751 363829 363960 364065 364066 364349 364472 364572 364708 364809 365050 365077 365109 365162 365223 365234
    365337 365377 365379 365459 365576 365578 365579 365598 365624 365653 365658 365718 365893 366015 366030 366089 366090
    366126 366220 366536 366599 366600 366601 366793 366857 366953 366966 367022 367033 367034 367131 367140 367267 367272
    367292 367490 367491 367508 367509 367511 367547 367561 367694 367696 367702 368115 368145 368164 368165 368233 368298
    368333 368449 368513 368539 368580 368607 368691 368729 368759 368781 368830 368849 368874 368905 369242 369253 369463
    369476 369514 369515 369516 369540 369549 369597 369749 369776 369861 369863 369961 369973 369974 369988 370081 370095
    370204 370281 370315 370322 370342 370368 370488 370495 370496 370497 370557 370662 370681 370809 370850 370870 370900
    371065 371066 371112 371202 371206 371318 371362 371365 371410 371428 371504 371569 371689 371927 371933 371989 372039
    372098 372192 372204 372207 372208 372209 372210 372251 372314 372359 372507 372542 372573 372763 372764 372765 372766
    372849 372983 373013 373014 373064 373190 373220 373227 373308 373343 373607 373809 373829 373846 373869 373909 373923
    374022 374034 374090 374097 374098 374099 374137 374219 374312 374318 374320 374411 374412 374490 374542 374661 374680
    374681 374706 374817 374842 374843 374864 374986 374998 375005 375006 375056 375166 375182 375268 375270 375396 375437
    375555 375667 375848 375849 375850 375853 375860 375916 375919 376007 376009 376427 376436 376606 376722 376764 376844
    376905 377007 377066 377451 377511 377697 377709 377835 377875 377889 378154 378162 378163 378175 378213 378214 378215
    378293 378311 378551 378621 378623 378696 378838 378842 378843 378876 378884 378962 378965 379183 379216 379527 379542
    379583 379663 379713 379715 379796 379959 380004 380005 380295 380338 380366 380368 380380 380413 380601 380685 380686
    380688 380800 380827 380846 380847 380899 380900 380901 380921 381072 381152 381242 381266 381284 381286 381335 381534
    381675 381680 381689 381708 381960 381979 381985 382021 382022 382035 382087 382095 382145 382493 382649 382650 382672
    382834 382904 382922 383145 383200 383201 383325 383329 383352 383353 383493 383494 383501 383613 383649 383869 383910
    384045 384145 384146 384475 384604 384730 384841 384877 385129 385546 385706 385734 386065 386105 386128 386152 386156
    386213 386329 386363 386701 386775 387089 387143 387207 387670 387673 387692 387841 387842 388002 388030 388271 388315
    388413 388563 388631 388714 388721 388729 388861 388933 388934 388935 388982 389037 389167 389168 389176 389180 389259
    389749 389756 389763 389839 389863 390340 390432 390463 390555 390627 390628 390709 390756 390842 390961 391020 391027
    391065 391263 391408 391410 391429 391559 391560 391582 391647 391658 391736 391737 391847 392024 392028 392105 392133
    392224 392304 392399 392464 392669 392772 392860 393340 393508 393509 393532 393730 394077 394234 394365 394415 394650
    394652 394732 394969 395142 395168 395505 395591 395659 395672 395675 395754 395770 395871 395933 395947 396206 396233
    396235 396237 396239 396268 396565 396566 396701 396885 396887 396888 396889 396893 397081 397122 397140 397443 397555
    397858 398063 398065 398068 398235 398316 398319 398625 399044 399205 399227 399462 399464 399478 399491 399583 399617
    399912 399943 399944 399984 400062 400300 400302 400639 400669 400863 401058 401204 401256 401308 401309 401311 401313
    401318 401325 401337 401338 401339 401344 401347 401348 401349 401351 401352 401353 401354 401355 401356 401357 401358
    401359 401365 401371 401373 401374 401375 401382 401388 401390 401401 401408 401413 401431 401445 401450 401452 401461
    401464 401511 401521 401524 401535 401539 401545 401560 401595 401631 401648 401661 401662 401663 401664 401666 401734
    401740 401745 401751 401759 401804 401919 401971 401973 401999
/);

$log->out('START');

foreach_shard mbid => \@mbids, with_undef_shard => 1, sub {
    my ($shard, $mbids_chunk) = @_;
    if ($shard) {
        $log->msg_prefix("[shard_$shard]");
        $log->out({mbids_chunk => $mbids_chunk});
        my $res = do_update_table(PPC(shard => $shard),
                        'mod_resync_media_queue',
                        {
                            'stop' => 0,
                        },
                        where => { 'mbid' => $mbids_chunk });
        $log->out("Rows updated, affected $res rows");
    } else {
        $log->msg_prefix(undef);
        $log->out({ERROR_mbids_without_shard => $mbids_chunk});
    }
};

$log->out('FINISH');

