#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
[{
  type => 'sql',
  webstop => "1",
  db => "ppc:all",
  when => 'before',
  time_estimate => "8 минут на devtest",
  sql => 'ALTER TABLE clients_options ADD COLUMN `subregion_id` int(10) unsigned DEFAULT NULL',
},
{
  type => 'script',
  when => 'after',
  time_estimate => "3-4 минуты",
}]

=cut

use my_inc '..';

use Direct::Modern;
use Yandex::DBTools;

use Settings;
use ScriptHelper;

use ShardingTools;


my $LIMIT = 500;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->msg_prefix("[shard_$shard] ");
    $log->out("start processing users");

    my $last_client_id = 0;
    while(1) {
        $log->out("Processing $LIMIT entries with ClientID > $last_client_id");
        my $clients_data = get_all_sql(PPC(shard => $shard),
            "SELECT u.ClientID, uo.geo_id
              FROM users u JOIN users_options uo USING(uid)
              WHERE uo.geo_id != 0 AND u.ClientID > $last_client_id ORDER BY u.ClientID LIMIT $LIMIT"
        );
        last unless (defined $clients_data && scalar @$clients_data);
        $last_client_id = $clients_data->[-1]->{ClientID};

        my @co_insert;
        for my $client (@$clients_data) {
            $log->out("Copy geo_id of client $client->{ClientID}: $client->{geo_id}");
            push @co_insert, [$client->{ClientID}, $client->{geo_id}];
        }
        do_mass_insert_sql(PPC(shard => $shard), "insert into clients_options (ClientID, subregion_id) values %s ON DUPLICATE KEY UPDATE subregion_id = VALUES(subregion_id)", \@co_insert);
    }

    $log->out("finish processing users");
}

$log->out('DONE');
