#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "около двух часов",
  comment => "запускать с параметром --no-dry-run

  на ТС запускать ДО запуска релизных автотестов"
}

=cut

use Direct::Modern;

use List::MoreUtils qw/uniq/;

use Yandex::Balance;
use Yandex::DBShards;
use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::Retry;

use my_inc '..';

use Client;
use geo_regions ();
use PrimitivesIds qw/get_clientids/;
use RBAC2::Extended;
use RBACDirect;
use ScriptHelper;
use Settings;

my $DRY_RUN = 1;

extract_script_params(
    'dry-run!' => \$DRY_RUN,
);

# закешируем себе хеш со списком стран, для валидации данных от баланса
my %countries;
foreach my $region (@geo_regions::COUNTRY_REGIONS) {
    $countries{ $region->{region_id} } = undef;
}

$log->out({'START' => \@ARGV});

my $rbac = RBAC2::Extended->get_singleton( 1 ) or $log->die("can't get rbac");

$log->out('fetch all agency uids');
my $ag_uids = rbac_get_all_agencies($rbac);

$log->out('convert agency uids to clientids');
my $ag_client_ids = get_clientids(uid => $ag_uids);
undef $ag_uids;
my $n = scalar(@$ag_client_ids);
$log->out("Got $n ClientIDs");

$log->out("fetch current direct countries");
my $current_countries = get_hash_sql(PPC(ClientID => $ag_client_ids), [
                                        'SELECT ClientID, country_region_id FROM clients',
                                        WHERE => { ClientID => SHARD_IDS },
                                    ]);
$log->out('got ' . scalar(keys(%$current_countries)) . ' rows');

my $balance_countries = {};
$log->out('fetch current balance countries');
my $chunk_size = 200;
my ($j, $m) = (0, int($n / $chunk_size));
for my $chunk (chunks($ag_client_ids, $chunk_size)) {
    $j++;
    my $prefix_guard = $log->msg_prefix_guard("[$j / $m]");

    $log->out('fetch one more chunk');

    for my $entry (@{ balance_get_clients($chunk) }) {
        my $country_id = $entry->{REGION_ID};
        my $client_id = $entry->{CLIENT_ID};

        if ($country_id && !exists $countries{$country_id}) {
            $log->out("WARNING: strange data from balance_get_clients for ClientID $client_id - REGION $country_id IS NOT A COUNTRY!");
            next;
        }
        $balance_countries->{$client_id} = $country_id || -1;
    }
}

$log->out("compare direct and balance countries");
my @ids_to_process;
for my $client_id (@$ag_client_ids) {
    my $balance_region_id = $balance_countries->{$client_id};
    my $direct_region_id = $current_countries->{$client_id};

    if (!defined $balance_region_id) {
        $log->out("Skipped ClientID: $client_id - WARNING: NO DATA FROM BALANCE");
        next;
    }

    if ($direct_region_id && $balance_region_id && $direct_region_id == $balance_region_id) {
        $log->out("Skipped ClientID: $client_id - countries equals: $direct_region_id");
        next;
    } else {
        push @ids_to_process, $client_id;
    }
}

$n = scalar(@ids_to_process);
$log->out("Got $n ClientIDs to process");

my $i = 0;
for my $client_id (@ids_to_process) {
    $i++;
    my $prefix_guard = $log->msg_prefix_guard("[$i / $n]");

    ### copy-paste from one-shot/setup_clients_country с поднятыми таймаутами
    # Страны нет :(
    my $NEW_COUNTRY_ID;

    # применяем "наш дедуктивный метод" (c)
    $log->out("Fetching data for ClientID: $client_id from balance");
    my $fcc;
    # и еще одно заevalированное место кода
    my $res = eval {
        $fcc = retry(tries => 5, pauses => [2, 4, 10], sub {
            return Yandex::Balance::balance_get_firm_country_currency($client_id, currency_filter => 1, timeout => 600);
        });
        return 1;
    };
    if (!$res) {
        # не получилось
        $log->out("Skipped ClientID: $client_id - WARNING: ERROR FETCHING FIRM COUNTRY CURRENCY DATA: " . ($@ =~ s![\r\n]+! / !gr) );
    } elsif ($fcc && ref $fcc eq 'ARRAY') {
        # looks good
        if (@$fcc) {
            my @possible_countries = uniq map { $_->{region_id} } @$fcc;
            if (scalar(@possible_countries) == 1) {
                # GOT IT!
                $NEW_COUNTRY_ID = $possible_countries[0];
            } else {
                $log->out("Skipped ClientID: $client_id - possible country is not unique");
            }
        } else {
            $log->out("Skipped ClientID: $client_id - got empty country currency data");
        }
    } else {
        # impossible
        $log->out("Skipped ClientID: $client_id - WARNING: INVALID FIRM COUNTRY CURRENCY DATA");
    }
    ### end-of-copypaste

    my $direct_country = $current_countries->{$client_id} || 'NO_COUNTRY';
    $log->out("ClientID: $client_id, direct country: $direct_country, balance country: " . ($NEW_COUNTRY_ID || 'NO_COUNTRY'));

    ### copy-paste from one-shot/setup_clients_country
    next unless $NEW_COUNTRY_ID;
    ### end-of-copypaste

    if ($NEW_COUNTRY_ID == $geo_regions::KAZ) {
        $log->out("Skipped ClientID: $client_id - don't touch Kazakh agencies at this moment");
        next;
    }

    ### copy-paste from one-shot/setup_clients_country
    if (!exists $countries{$NEW_COUNTRY_ID}) {
        # very strange...
        $log->out("Skipped ClientID: $client_id - WARNING: REGION $NEW_COUNTRY_ID IS NOT A COUNTRY!");
        next;
    }

    $log->out("Processing ClientID: $client_id");
    if ($DRY_RUN) {
        $log->out("Skipped ClientID: $client_id - don't update anything in dry-run mode");
        next;
    }
    # уровень вложенности eval'ов зашкаливает...
    my $transaction_result = eval {
        do_in_transaction {
            # in direct
            create_update_client({
                client_data => {
                    ClientID            => $client_id,
                    country_region_id   => $NEW_COUNTRY_ID,
                    user_is_not_created => 1, # for updating last_change in users
                },
            });
            # in balance    #UID
            update_client_id(1, $client_id, {REGION_ID => $NEW_COUNTRY_ID}) == 0 or $log->die("error updating ClientID $client_id in balance");
        };
        return 1;
    };
    if (!$transaction_result) {
        $log->out("Processing ClientID: $client_id REGION_ID: $NEW_COUNTRY_ID - FAILED: " . ($@ =~ s![\r\n]+! / !gr));
    } else {
        $log->out("Processing ClientID: $client_id REGION_ID: $NEW_COUNTRY_ID - SUCCESS");
    }
    ### end-of-copypaste
}

$log->out('FINISH');

