#!/usr/bin/perl

=head1 DEPLOY
# approved by lena-san

#.migr
[
{
  type => 'sql',
  webstop => "0",
  db => "ppc:all",
  when => 'before',
  time_estimate => "1 минута + 1 секунда + 1 секунда на каждый шард",
  sql => [
    "delete qb from banner_images_process_queue_bid qb left join banner_images_process_queue q using(imq_id) where q.imq_id is null",
    "alter table banner_images_process_queue_bid add column job_id bigint(20) unsigned not null, add column xls_id int(10) unsigned not null, ALGORITHM INPLACE, LOCK NONE",
    "alter ignore table banner_images_process_queue_bid add unique key (job_id, bid)",
  ]
},
{
  type => 'script',
  when => 'after',
  time_estimate => "5 минут",
  comment => "Копируем задания из старой очереди скачивания картинок в новую"
},
]

=cut

use Direct::Modern;
use my_inc '..';

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry qw/relaxed_guard/;


use Yandex::DBQueue;

use ScriptHelper;
use Settings;
use ShardingTools qw/ppc_shards/;

$log->out('START');

my $chunk = 50_000;

=head1 TESTING

Как тестировать:
1) На бете со старым кодом: Загрузить xls или добавить картинки на скачивание через api
1.1) Проверить, что задания попали в старую очередь:
    select url from banner_images_process_queue where url = "URL картинки";
2) запустить миграцию (только скрипт)
3) запустить ppcProcessImageQueue.pl

=cut

for my $shard (ppc_shards()) {
    my $mpg = $log->msg_prefix_guard("[ppc:$shard]");
    my ($min, $max) = get_one_line_array_sql(PPC(shard => $shard), "select min(imq_id), max(imq_id) from banner_images_process_queue");
    $log->out("begin table: $min .. $max");
    my $queue = Yandex::DBQueue->new(PPC(shard => $shard), 'banner_images');
    while ($min <= $max) {
        my $rows = get_all_sql(PPC(shard => $shard), "
            select q.*, u.uid
            from banner_images_process_queue q
            join users u using(ClientID)
            where imq_id between ? and ?
            and status in ('New','Process')",
            $min, $min + $chunk - 1
        );
        $log->out("$min / $max: ".(scalar @$rows)." rows");
        for my $row (@$rows) {
            my $rg = relaxed_guard times => 1;
            my $job = $queue->insert_job({
                job_id => get_new_id('job_id'),
                uid => $row->{uid},
                ClientID => $row->{ClientID},
                args => {
                    url => $row->{url},
                    name => $row->{name},
                    xls_id => $row->{xls_id},
                },
            });
            do_update_table(PPC(shard => $shard),
                'banner_images_process_queue_bid',
                { job_id => $job->job_id, xls_id => $row->{xls_id} },
                where => {
                    imq_id => $row->{imq_id},
                },
            )
        }
        
        $min += $chunk;
    }
}

$log->out('FINISH');

