#!/usr/bin/perl


=head1 DEPLOY
# approved by zhur
# .migr

{
  type => 'script',
  when => 'after',
  time_estimate => "~1,5 суток на devtest",
  comment => "Проверка, превышено ли где в базе максимальное значение в 200 фраз для групп клиентов,
              и установка этого превышенного значения в таблицу с огранчениями client_limits."
}

=cut

use Direct::Modern;
use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

use ShardingTools qw/ppc_shards/;
use Client;

$log->out('START');

my $CLIENTS_IDS_CHUNK_SIZE = 3000;
my $MAX_PHARSES = 200;

sub update_client_keywords_limit {
    my ($shard, $client_id, $keywords_limit) = @_;

    if (!defined $client_id){
        return;
    }

    $log->out("Update for client id $client_id: $keywords_limit");
    Client::set_client_limits($client_id, {keyword_count_limit  => $keywords_limit});
}

sub process_clients_ids {
    my ($shard, $clients_ids) = @_;
    $log->msg_prefix("[shard $shard] ");

    $log->out("fetched clients_ids cnt, len: ".scalar(@{$clients_ids}));

    my $phrases = get_all_sql(
        PPC(shard => $shard),
        [
            "SELECT COUNT(bi.id) AS cnt, bi.pid, us.ClientID "
            ."FROM users us LEFT JOIN campaigns ci on us.uid = ci.uid LEFT JOIN bids bi ON (ci.cid = bi.cid) ",
            WHERE => {"us.ClientID" => $clients_ids},
            "GROUP BY us.ClientID, bi.pid HAVING cnt > $MAX_PHARSES ORDER BY us.ClientID",
        ]
    );

    $log->out("fetched groups, len: ".scalar(@{$phrases}));

    my $current_client_id = undef;
    my $max_keywords_limit = 0;

    for my $elem (@{$phrases}){
        if (defined $current_client_id and $current_client_id != $elem->{ClientID}){
            update_client_keywords_limit($shard, $current_client_id, $max_keywords_limit);
            $max_keywords_limit = 0;
        }

        $current_client_id = $elem->{ClientID};
        if ($elem->{cnt} > $max_keywords_limit){
            $max_keywords_limit = $elem->{cnt};
        }
    }

    update_client_keywords_limit($shard, $current_client_id, $max_keywords_limit);
}

my ($shard_num, @clients_ids_argv) = @ARGV;

if (defined $shard_num){
    process_clients_ids($shard_num, \@clients_ids_argv);
}
else{
    for my $shard (ppc_shards()) {
        $log->msg_prefix("[shard $shard] ");

        my $clients_ids_cnt = get_one_field_sql(
            PPC(shard => $shard),
            "SELECT COUNT(ClientID) FROM users"
        );

        $log->out("Total clients from shard: $clients_ids_cnt");

        for(my $i = 0; $i < $clients_ids_cnt; $i += $CLIENTS_IDS_CHUNK_SIZE){
            $log->out("Step number: $i");
            my $clients_ids = get_one_column_sql(
                PPC(shard => $shard),
                "SELECT ClientID FROM users ORDER BY ClientID LIMIT $CLIENTS_IDS_CHUNK_SIZE OFFSET $i"
            );

            process_clients_ids($shard, $clients_ids);
        }

        $log->out("Done");
    }
}

$log->out('FINISH');
