#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "дней 20 на devtest",
  comment => "Подключаем ОС легким клиентам"
}

=cut

use Direct::Modern;

use my_inc '..';

use Settings;

use Yandex::DBTools;
use Yandex::DBShards;

use DirectContext;
use RBAC2::Extended;
use ShardingTools qw/foreach_shard_parallel_verbose/;
use EnvTools qw//;
use Wallet qw//;

use ScriptHelper;

my $STEP = 100_000;

my $uid;
extract_script_params(
    'uid=i' => \$uid,
);

$log->out($uid ? "START (uid=$uid)" : "START");

my $uid_shard = $uid ? get_shard(uid => $uid) : undef;
$log->die("Cannot find uid $uid") if $uid && !$uid_shard;

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;

    return if $uid_shard && $shard != $uid_shard;

    my $rbac = eval { RBAC2::Extended->get_singleton(1) } or $log->die("Error initialising RBAC: $@");

    my ($uid_next, $uid_max);
    if (!$uid_shard) {
        ($uid_next, $uid_max) = get_one_line_array_sql(PPC(shard => $shard), "SELECT MIN(uid), MAX(uid) FROM users");
    } else {
        ($uid_next, $uid_max) = ($uid, $uid);
    }

    while ($uid_next <= $uid_max) {
        my $easy_users = get_all_sql(PPC(shard => $shard), "
            SELECT u.uid, u.ClientID, u.login, IFNULL(cl.work_currency, 'YND_FIXED') AS work_currency,
                   COUNT(IF(c.type = 'wallet', 1, NULL)) AS has_wallet,
                   COUNT(IF(c.AgencyUID > 0, 1, NULL)) AS has_agency,
                   COUNT(IF(c.type = 'text', 1, NULL)) AS has_camps
            FROM users u
            JOIN users_options uo ON (uo.uid = u.uid)
            LEFT JOIN clients cl ON (cl.ClientID = u.ClientID)
            LEFT JOIN campaigns c ON (
                c.uid = u.uid AND
                IFNULL(c.currency, 'YND_FIXED') = IFNULL(cl.work_currency, 'YND_FIXED')
            )
            WHERE uo.uid >= $uid_next AND uo.uid < @{[$uid_next + $STEP]} AND uo.uid <= $uid_max AND uo.statusEasy = 'Yes'
            GROUP BY u.uid
            HAVING has_wallet = 0
        ");
        $uid_next += $STEP;

        $log->out("Processing @{[scalar(@$easy_users)]} easy users") if @$easy_users;

        for my $user (@$easy_users) {
            if ($user->{has_agency}) {
                $log->out({"Skippind record due to `has_agency`" => $user});
                next;
            }

            my $context = DirectContext->new({
                UID => $user->{uid},
                uid => $user->{uid},
                client_chief_uid => $user->{uid},
                client_client_id => $user->{ClientID},
                login_rights => {},
                rbac => $rbac,
                site_host => "yandex.ru",
                is_beta => EnvTools::is_beta(),
            });

            my $result;
            eval {
                $result = Wallet::enable_wallet($context, $user->{work_currency}, 0, allow_wallet_before_first_camp => 1);
                1;
            } or do {
                $result = {error => $@};
            };

            if ($result and $result->{wallet_cid}) {
                my $sth = exec_sql(PPC(ClientID => $context->client_client_id), 
                        "update campaigns wc, 
                        (select ifnull(max(c.statusMail),0) maxStatusMail from campaigns c where c.uid=? and c.wallet_cid=?) t 
                        set wc.statusMail = t.maxStatusMail where wc.cid=?",
                        $context->client_chief_uid, $result->{wallet_cid}, $result->{wallet_cid}
                );
            }

            my $prefix = !$user->{has_camps} ? "[NoCamps] " : "";
            $log->out({$prefix."Enabling wallet for (uid => @{[$user->{uid}]}, login => \"@{[$user->{login}]}\")" => $result});
        }
    }

    $log->out("Done");
});

$log->out('FINISH');
