#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "около двух часов на devtest",
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::Retry;

use my_inc '..';

use PrimitivesIds qw/get_clientids/;
use RBAC2::Extended;
use RBACDirect;
use ScriptHelper;
use Settings;
use ShardingTools;

# ctrl+c ctrl+v
my @TABLES_TO_CLEANUP_BY_CLIENTID = qw/
    client_firm_country_currency
    clients_to_force_multicurrency_teaser
    force_currency_convert
    client_teaser_data_lastupdate
/;

$log->out('START');

my $rbac = RBAC2::Extended->get_singleton( 1 ) or $log->die("can't get rbac");

$log->out('fetch all agency uids');
my $ag_uids = rbac_get_all_agencies($rbac);

$log->out('convert agency uids to clientids');
my %ag_client_ids = map { $_ => undef } @{ get_clientids(uid => $ag_uids) };
undef $ag_uids;
my $n = scalar(keys %ag_client_ids);
$log->out("Got $n Agency ClientIDs to skip");

for my $SHARD (ppc_shards()) {
    my $log_prefix_guard = $log->msg_prefix_guard("[shard $SHARD]");

    $log->out('fetch clients in currency');
    my $client_ids = get_one_column_sql(PPC(shard => $SHARD), ['SELECT ClientID FROM clients WHERE IFNULL(work_currency, "YND_FIXED") != "YND_FIXED"']);
    $log->out('got ' . scalar(@$client_ids) . ' ClientIDs');

    $log->out('exclude agency ClientIDs');
    @$client_ids = grep { !exists $ag_client_ids{$_}  } @$client_ids;
    $log->out('got ' . scalar(@$client_ids) . ' ClientIDs to process');

    for my $chunk (chunks($client_ids, 100)) {
        relaxed times => 1, sub {
            TABLE: for my $table (@TABLES_TO_CLEANUP_BY_CLIENTID) {
                $log->out("fetch old data from table $table");
                my $old_data = get_all_sql(PPC(shard => $SHARD), ["SELECT * FROM $table", WHERE => {ClientID => $chunk}]);
                next TABLE if !@$old_data;

                $log->out({backup => $old_data, table => $table});

                my @to_delete;
                for my $row (@$old_data) {
                    push @to_delete, _AND => $row;
                }

                for my $delete_chunk (chunks(\@to_delete, 10_000)) {
                    $log->out("delete data chunk from table $table");
                    my $res = do_delete_from_table(PPC(shard => $SHARD), $table, where => { _OR => $delete_chunk });
                    $log->out("deleted $res rows from table $table");
                }
            }

            $log->out("fetch old data from table currency_converted_orders");
            my $orderids = get_one_column_sql(PPC(shard => $SHARD), [
                                                'SELECT STRAIGHT_JOIN cco.OrderID',
                                                'FROM users u',
                                                'JOIN campaigns c ON c.uid = u.uid',
                                                'JOIN currency_converted_orders cco ON cco.OrderID = c.OrderID',
                                                WHERE => {
                                                    'u.ClientID' => $chunk,
                                                },
                                              ]);

            return if !@$orderids;

            $log->out({backup => $orderids, table => 'currency_converted_orders'});
            for my $delete_chunk (chunks($orderids, 5_000)) {
                $log->out('delete data chunk from table currency_converted_orders');
                my $res = do_delete_from_table(PPC(shard => $SHARD), 'currency_converted_orders', where => {OrderID => $delete_chunk});
                $log->out("deleted $res rows from table currency_converted_orders");
            }
        };
    }
}

$log->out('FINISH');

