#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "10 минут на devtest",
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use Settings;
use ScriptHelper;


my $CLIENT_ID_CHUNK_SIZE = 5000;
my $SHARD_CHUNK_SIZE = 500;

my $data_path = my_inc::path('./20160405_set_customers_city_geo_id_from_balance.data');

my @loaded_data;

$log->out('START');

$log->out("Load clients subregion data from file file $data_path");
open (my $fh, '<', $data_path) or $log->die("Error opening file: $!");
my $cnt = 0;
while (my $line = <$fh>) {
    # Строка - "12345\t54321\r\n", первое число - ClientID, второе subregion_id
    if ($line =~ m/^(\d+)\t(\d+)\r$/) {
        push @loaded_data, {ClientID => $1, subregion_id => $2};
        $cnt++;
    } else {
        $log->out("invalid data line: $line");
    }
}
close ($fh) or $log->die("Error closing file: $!");

$log->out("Got $cnt clients to set subregion");

while (my @data_chunk = splice @loaded_data, 0, $CLIENT_ID_CHUNK_SIZE) {
    $log->out("Start processing of new chunk of $CLIENT_ID_CHUNK_SIZE clients");

    foreach_shard ClientID => \@data_chunk, chunk_size => $SHARD_CHUNK_SIZE, sub {
        my ($shard, $chunk) = @_;

        $log->msg_prefix("[shard_$shard] ");
        my $count = scalar @$chunk;

        $log->out("Got chunk of $count clients");

        my @client_ids = map {$_->{ClientID}} @$chunk;
        my $is_direct_client = get_hash_sql(PPC(shard => $shard),
                ["SELECT ClientID, country_region_id FROM clients",
                 WHERE => {ClientID => \@client_ids}]
        );
        my @data_to_insert = map { [$_->{ClientID}, $_->{subregion_id}] }
                            grep { exists $is_direct_client->{$_->{ClientID}} } @$chunk;

        return unless scalar @data_to_insert;

        $count = scalar @data_to_insert;
        $log->out("Will insert or update $count clients");

        do_mass_insert_sql(PPC(shard => $shard), 'insert into clients_options (ClientID, subregion_id) values %s ON DUPLICATE KEY UPDATE subregion_id = VALUES(subregion_id)', \@data_to_insert);
    };
}

$log->out('FINISH');
