#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "10 секунд",
  comment => "Удаляем кампанию 4825947"
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;
use Campaign;
use RBAC2::Extended;

# кампания для удаления
my $bad_cid = 4825947;

my $rbac = RBAC2::Extended->get_singleton(1);

$log->out('START');

my $camp = get_one_line_sql(PPC(cid => $bad_cid), ["select cid, uid from campaigns",  where => {cid => $bad_cid}]);

$log->out("Start process cid: $camp->{cid}, uid: $camp->{uid}");
my $ret = eval {
    del_camp($rbac, $camp->{cid}, $camp->{uid},
             force => 1,
             ignore_rbac_errors => 1,
        );
};
if ($@ || !$ret) {
    $log->out("Can't delete campaign $camp->{cid}: $@");
}

$log->out('FINISH');
