#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 минута",
  comment => "Останавливаем переотправленные через ленивую очередь и отклоненные на модерации медийные баннеры"
}

=cut

use Direct::Modern;

use Yandex::DBShards;
use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

use Path::Tiny;

my $data_path = my_inc::path('./20160422_stop_rejected_media_banners.data');

$log->out('START');

my @mbids = path($data_path)->lines({ chomp => 1}) or $log->die("Can't open data file $data_path: $@");

$log->out('Got '. scalar @mbids .' mbids for check');

foreach_shard mbid => \@mbids, chunk_size => 1_000, with_undef_shard => 1, sub {
    my ($shard, $mbids_chunk) = @_;

    # ошибка, если не определили шард
    if (!$shard) {
        $log->msg_prefix("[shard=undef]");
        $log->out({mbids => $mbids_chunk});
        return;
    }

    $log->msg_prefix("[shard=$shard]");
    $log->out('Got '. scalar @$mbids_chunk .' mbids for check');

    # останавливаем отклоненные баннеры
    if (@$mbids_chunk) {
        my $bids_to_stop = get_one_column_sql(PPC(shard => $shard), ["select b.mbid from media_banners b", where => {'b.mbid' => $mbids_chunk, 'b.statusModerate' => 'No'}]);
        $log->out({bids_to_stop => $bids_to_stop});
        do_update_table(PPC(shard => $shard),
                    'media_banners b',
                    {
                        'b.statusShow' => 'No',
                        'b.statusBsSynced' => 'No',
                    },
                    where => {
                        'b.mbid' => $bids_to_stop,
                        'b.statusModerate' => 'No'
                    });
    }
};

$log->out('FINISH');

