#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '5 секунд',
  comment => 'Заполняем типы целей в таблице retargeting_goals',
}

=cut

use Direct::Modern;

use my_inc '..';

use Yandex::DBTools;

use ScriptHelper;
use Settings;
use ShardingTools qw(ppc_shards);
use Primitives qw//;

$log->out('START');

for my $shard (ppc_shards()) {

    $log->out("updating shard: $shard");

    my $goal_ids = get_one_column_sql(PPC(shard => $shard), 'SELECT goal_id FROM retargeting_goals WHERE goal_type IS NULL OR goal_type=""');

    my $updated = do_mass_update_sql(PPC(shard => $shard), 'retargeting_goals',
        goal_id => {map {$_ => {goal_type => Primitives::get_goal_type_by_goal_id($_)}} @$goal_ids},
    );

    $log->out("Updated $updated records");
}

$log->out('FINISH');
