#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '3 секунды',
  comment => 'добавляем для Я.Аудиторий дефолтное время',
}

=cut


use Direct::Modern;

use my_inc '..';

use Yandex::DBTools;
use JSON;
use Retargeting qw//;
use ScriptHelper;
use Settings;
use ShardingTools qw(ppc_shards);

$log->out('START');

for my $shard (ppc_shards()) {

    $log->out("updating shard: $shard");

    # записей порядка ~ 10
    my $ret_cond_ids = get_one_column_sql(PPC(shard => $shard), "select distinct ret_cond_id from retargeting_goals where goal_type = 'audience'");
    $log->out(sprintf "found %d retargetings", scalar @$ret_cond_ids);

    for my $id (@$ret_cond_ids) {
        do_in_transaction {
            my $ret = get_one_line_sql(PPC(shard => $shard), ["select * from retargeting_conditions", WHERE => {ret_cond_id => $id}, 'for update']);
            $ret->{condition} = from_json($ret->{condition_json});
            Retargeting::save_retargeting_condition(ClientID => $ret->{ClientID}, $ret);
            if ($ret->{is_deleted}) {
                do_update_table(PPC(shard => $shard), 'retargeting_conditions', {is_deleted => 1}, where => {ret_cond_id => $id});
            }
        };
        $log->out("ret_cond_id $id updated");
    }
}

$log->out('FINISH');
