#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '5 секунд на devtest, но на devtest данных очень мало',
  comment => 'Исправление формата хранения причин отклонения для перфоманс-креативов',
}

=cut

use YAML::Syck;

use Direct::Modern;

use my_inc '..';

use Yandex::DBTools;

use ScriptHelper;
use Settings;
use ShardingTools qw(ppc_shards);

$log->out('START');

for my $shard (ppc_shards()) {
    $log->msg_prefix("[shard_$shard]");
    my $reasons = [];
    do {
        do_in_transaction {
            $reasons = lock_next_reasons($shard);
            $log->out(sprintf "selected %d reasons", scalar @$reasons);
            $log->out(join ',', map { $_->{rid} } @$reasons) if @$reasons;
            if (@$reasons) {
                update_mod_reasons($shard => $reasons);
            }
        };
    } while (@$reasons);
}

$log->out('FINISH');

sub update_mod_reasons {
    my ($shard, $reasons) = @_;

    my %case;
    for my $r (@$reasons) {
        my $reason = YAML::Syck::Load($r->{reason});
        if (@$reason && ref $reason->[0] ne 'HASH') { 
            $case{$r->{rid}} = { reason => YAML::Syck::Dump([map { {id => $_} } @$reason]) };
        }
    }

    do_mass_update_sql(PPC(shard => $shard),
        mod_reasons => 'rid',
        \%case,
        where => {rid => [keys %case]}
    );

    $log->out("updated rid=" . join ',', keys %case) if scalar keys %case;
}

sub lock_next_reasons {
    my $shard = shift; 

    state $last_shard;
    state $last_rid;
    if (!defined $last_shard || $last_shard != $shard) {
        $last_rid = 0;
        $last_shard = $shard;
    }
    my $reasons = get_all_sql(PPC(shard => $shard),
                    "SELECT r.rid, r.reason FROM perf_creatives perfc join mod_reasons r on r.type = 'perf_creative' and r.id = perfc.creative_id WHERE r.rid > ? ORDER BY rid LIMIT 100 FOR UPDATE",
                    $last_rid
                );
    $last_rid = $reasons->[-1]->{rid} if @$reasons; 
    return $reasons;
}

