#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
[
    {
        type => 'script',
        when => 'after',
        time_estimate => 'несколько дней',
        comment => q[
            Увеличиваем размерности BannerID и GoalID всюду, попутно в задетых таблицах ещё и bid и ContextID
            Сам скрипт альтерит таблицы с детальной статистикой в ppcstat_data.

            Поддерживаемые параметры:
                --one-shard - для тестовых систем, будет использован только первый шард
                --test-only - запуск без применения альтера
                --skip-column-check - пропуск проверки применённости альтера

            Скрипт можно останавливать/перезапускать.
            При первом запуске лучше указать --skip-column-check для экономии времени.
            После перезапуска можно --skip-column-check указывать также, но в этом случае в логах могут появиться сообщения о том,
            что альтеры уже были применены.
        ],
    },
    {
        type => 'sql',
        when => 'any',
        db => 'ppc:all',
        webstop => 1,
        time_estimate => '
banner_images ~20 минут на каждый шард,
media_banners меньше минуты на шард,
bs_media_stat меньше минуты на шард,
retargeting_goals меньше минуты на шард,
camp_metrika_goals ~5 минут на шард
',
        sql => [
            # banners не альтерим, т.к. сомневаемся в производительности (увеличатся в размере индексы)
            # ждём приезда новых шардов и починки решардинга
            # его альтер через pt-o-s-c на devtest занял порядка суток
            #'ALTER TABLE banners
            #    MODIFY COLUMN `BannerID` bigint(20) NOT NULL,
            #    MODIFY COLUMN `bid` bigint(20) NOT NULL
            #',
            'ALTER TABLE banner_images
                MODIFY COLUMN `BannerID` bigint(20) NOT NULL DEFAULT 0,
                MODIFY COLUMN `bid` bigint(20) NOT NULL,
                MODIFY COLUMN `image_id` bigint(20) NOT NULL
            ',
            'ALTER TABLE media_banners
                MODIFY COLUMN `BannerID` bigint(20) NOT NULL DEFAULT 0,
                MODIFY COLUMN `ContextID` bigint(20) NOT NULL DEFAULT 0
            ',
            'ALTER TABLE bs_media_stat
                MODIFY COLUMN `BannerID` bigint(20) NOT NULL
            ',
            'ALTER TABLE retargeting_goals
                MODIFY COLUMN `goal_id` bigint(20) NOT NULL DEFAULT 0
            ',
            'ALTER TABLE camp_metrika_goals
                MODIFY COLUMN `goal_id` bigint(20) NOT NULL
            ',
        ],
    },
    {
        type => 'sql',
        when => 'any',
        db => 'ppcdict',
        webstop => 1,
        time_estimate => 'порядка 5 минут',
        sql => [
            'ALTER TABLE metrika_goals
                MODIFY COLUMN `goal_id` bigint(20) NOT NULL,
                MODIFY COLUMN `parent_goal_id` bigint(20) DEFAULT NULL
            ',
        ],
    },
]

=cut

use strict;
use warnings;

use my_inc '..';

use utf8;
use open ':std' => ':utf8';

use my_inc '..';

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Parallel::ForkManager;

my ($one_shard, $test_only, $skip_column_check);
extract_script_params(
    'one-shard' => \$one_shard,
    'test-only' => \$test_only,
    'skip-column-check' => \$skip_column_check,
);

$log->out('START');

my %result;
{;
    my %childs;

    local $SIG{INT} = sub {
        kill 9 => keys %childs;
        exit 1;
    };
    local $SIG{TERM} = sub {
        kill 9 => keys %childs;
        exit 1;
    };

    my $shards = get_db_childs("ppcstat");
    $shards = [shift @$shards] if $one_shard && @$shards;

    my $pm = new Parallel::ForkManager(scalar @$shards);
    $pm->run_on_finish(sub {
        my ($pid, $exit, $shard) = @_;
        $result{$shard} = defined $exit && $exit == 0 ? 1 : 0;
    });

    for my $shard (@$shards) {
        $log->out("starting process for $shard");
        if (my $pid = $pm->start($shard)) {
            $childs{$pid} = 1;
            next;
        }

        $SIG{INT} = $SIG{TERM} = 'DEFAULT';

        my ($shard_id) = ($shard =~ /^ppcstat:(\d+)$/);
        my $log_file_name = get_script_name(shardid => $shard_id).".log";
        $0 .= " SHARD - $shard_id";
        my $log = Yandex::Log->new(log_file_name => $log_file_name, date_suf => '%Y%m%d');
        eval {
            $log->out("$shard start");
            alter_columns($shard, $log);
            $log->out("$shard finish");
            1;
        } or do {
            $log->out("$shard: $@");
        };

        $pm->finish($@ ? 1 : 0);
    }

    $pm->wait_all_children;
};

sub alter_columns {
    my ($shard, $log) = @_;

    my $dbh = get_dbh($shard);

    my $alter = q{
        ALTER TABLE ppcstat_data.%s
            MODIFY COLUMN `BannerID` bigint(20) NOT NULL
    };

    my $tables = get_one_column_sql($dbh, q{
        SELECT t.TABLE_NAME
        FROM information_schema.tables t
        WHERE
            t.TABLE_SCHEMA = "ppcstat_data" AND (}.join(' OR ', map { "t.TABLE_NAME LIKE \"${_}%\"" } qw/order_stat order_stat_small/).q{)
    });
    my ($q, $total) = (0, scalar @$tables);

    $log->out("$shard has $total tables");
    @{$dbh}{qw/PrintError RaiseError/} = (0, 1);
    foreach my $t (@$tables) {
        my $is_altered = $skip_column_check ? 0 : get_one_field_sql($dbh, q{
            SELECT count(*)
            FROM information_schema.columns c
            WHERE
                c.TABLE_SCHEMA = "ppcstat_data" AND c.TABLE_NAME = ? AND c.COLUMN_NAME = "BannerID" AND c.DATA_TYPE != "bigint"
        }, $t);

        if (!$is_altered && !$test_only) {
            $log->out("altering table $t");
            eval {
                do_sql($dbh, sprintf($alter, $t));
                1;
            } or do {
                $log->out("$shard $t: $@");
            };
        }

        $log->out("$shard $q/$total tables done") unless ++$q % 1000;
    }
}

$log->out("$_ exit status: ".($result{$_} ? "OK" : "ERROR")) for keys %result;

$log->out('FINISH');
