#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '4 минуты на devtest на всех шардах',
  comment => 'унифицируем retargeting_conditions.condition_json',
}

=cut

use Direct::Modern;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw/ppc_shards/;

use Yandex::DBTools;
use Yandex::Retry qw/relaxed/;

use Direct::Model::RetargetingCondition;
use Direct::Model::RetargetingCondition::Manager;

my $SLEEP_COEF = 1;
my $STEP = 1_000;

extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
);

$log->out('START');

for my $shard (ppc_shards()) {
    my $guard = $log->msg_prefix_guard("[shard_$shard]");

    my ($next_ret_cond_id, $max_ret_cond_id) = get_one_line_array_sql(PPC(shard => $shard), "SELECT MIN(ret_cond_id), MAX(ret_cond_id) FROM retargeting_conditions");
    while ($next_ret_cond_id <= $max_ret_cond_id) {
        $log->out("Updating ret_cond_id [$next_ret_cond_id, @{[$next_ret_cond_id + $STEP]}) / $max_ret_cond_id");

        my $ret_cond_rows = get_all_sql(PPC(shard => $shard), ["
            SELECT ret_cond_id, ClientID, condition_json, modtime
            FROM retargeting_conditions
            WHERE ret_cond_id >= $next_ret_cond_id AND ret_cond_id < @{[$next_ret_cond_id + $STEP]}
        "]);
        $next_ret_cond_id += $STEP;

        my $ret_conds = [];
        my $cache;
        for my $row (@$ret_cond_rows) {
            eval {
                push @$ret_conds, Direct::Model::RetargetingCondition->from_db_hash($row, \$cache);
                1;
            } or do {
                $log->out({"Invalid retargeting condition:" => {row => $row, error => $@}});
            };
        }

        $_->condition($_->condition) for @$ret_conds; # force serialize to json

        relaxed times => $SLEEP_COEF, sub {
            Direct::Model::RetargetingCondition::Manager->new(items => $ret_conds, skip_goals_update => 1)->update();
        };
    }
}

$log->out('FINISH');
