#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '10 секунд',
  comment => 'заменяем тип условия "like" на "ilike"',
}

=cut


use Direct::Modern;

use my_inc '..';

use Yandex::DBTools;
use ScriptHelper;
use Settings;
use ShardingTools qw/foreach_shard_parallel_verbose/;
use Yandex::Retry qw/relaxed/;
use Direct::Model::PerformanceFilter;
use Direct::Model::PerformanceFilter::Manager;
use Yandex::Clone qw/yclone/;
my $SLEEP_TIME_COEF = 1;

$log->out('START');

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;
    my $perf_filters = [];
    my $last_perf_filter_id = 0;
    my $_cache;
    my $log_prefix_guard = $log->msg_prefix_guard("shard $shard:");
    my $max_perf_filter_id = get_one_field_sql(PPC(shard => $shard), "SELECT MAX(perf_filter_id) FROM bids_performance");
    do {
        relaxed times => $SLEEP_TIME_COEF, sub {
            $log->out('Fetching perf_filter chunk to fix');
            do_in_transaction {
                $perf_filters = get_all_sql(PPC(shard => $shard), 
                    'SELECT * FROM bids_performance WHERE perf_filter_id >? AND perf_filter_id <= ? ORDER BY perf_filter_id LIMIT ? FOR UPDATE', $last_perf_filter_id, $max_perf_filter_id, 100);
                my $perf_filters_cnt = scalar @$perf_filters;
                $log->out("Got $perf_filters_cnt filters to check and fix");
                if ($perf_filters_cnt) {
                    $last_perf_filter_id = $perf_filters->[-1]->{perf_filter_id};
                    my $perf_filter_models = [];
                    foreach my $perf_filter (@$perf_filters) {
                        my $perf_filter_model;
                        eval {
                            $perf_filter_model = Direct::Model::PerformanceFilter->from_db_hash($perf_filter, \$_cache);
                        };

                        if ($@ || !$perf_filter_model) {
                            $log->out(($@) ? $@ : sprintf("Could create Direct::Model::PerformanceFilter model by data: %d", Data::Dumper($perf_filter)));
                            next;
                        }

                        foreach my $cond (@{$perf_filter_model->condition}) {
                            if ($cond->relation eq 'like') {
                                $cond->relation('ilike');
                                $log->out(sprintf("like -> ilike perf_filter_id: %d", $perf_filter_model->id));
                            }
                            if ($cond->relation eq 'not like') {
                                $cond->relation('not ilike');
                                $log->out(sprintf("not like -> not ilike perf_filter_id: %d", $perf_filter_model->id));
                            }
                        }
                        $perf_filter_model->condition(yclone($perf_filter_model->condition));
                        if ($perf_filter_model->is_condition_changed) {
                            $perf_filter_model->do_update_adgroup_last_change(1);
                            $perf_filter_model->do_bs_sync_adgroup(1);
                            $perf_filter_model->do_bs_sync_banners(1);
                            push @$perf_filter_models, $perf_filter_model;
                        }
                    }
                    Direct::Model::PerformanceFilter::Manager->new(items => $perf_filter_models)->update();
                }
            };
        };
    } while @$perf_filters > 0;
});

$log->out('FINISH');
