#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '11 минут',
  comment => 'clients.deleted_reps содержит только uidы, заменяем их для на json строки с данными еще о логине, ФИО и пр.
              Скрипт можно в любой момент останавливать и запускать заново',
}

=cut


use Direct::Modern;

use my_inc '..';

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::HashUtils;
use ScriptHelper;
use Settings;
use ShardingTools qw/foreach_shard_parallel_verbose/;
use Yandex::Retry qw/relaxed/;
use Yandex::Validate qw/is_valid_id/;

use Primitives;
use JSON;

my $SLEEP_TIME_COEF = 1;
my $CLIENT_ID = 0;

$log->out('START');

extract_script_params(
    'client-id:i'    => \$CLIENT_ID,
);

my $client_shard = get_shard(ClientID=>$CLIENT_ID);

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;
    return if ($CLIENT_ID && $shard != $client_shard);
    my $clients_deleted_reps = [];
    my $last_clientid = 0;
    my $max_clientid = get_one_field_sql(PPC(shard => $shard), "SELECT MAX(clientid) FROM clients");
    do {
        relaxed times => $SLEEP_TIME_COEF, sub {
            do_in_transaction {

                if ($CLIENT_ID) {
                    $clients_deleted_reps = get_all_sql(PPC(shard => $shard), 
                        'SELECT clientid, deleted_reps FROM clients WHERE clientid = ? AND 
                        deleted_reps is not NULL AND deleted_reps != "" FOR UPDATE', $CLIENT_ID);
                } else {
                    $clients_deleted_reps = get_all_sql(PPC(shard => $shard), 
                        'SELECT clientid, deleted_reps FROM clients WHERE clientid > ? AND clientid <= ? AND 
                        deleted_reps is not NULL AND deleted_reps != "" ORDER BY clientid LIMIT ? FOR UPDATE',
                        $last_clientid, $max_clientid, 100);
                }

                my $clients_cnt = scalar @$clients_deleted_reps;
                $log->out("Got $clients_cnt filters to check and fix");
                if ($clients_cnt) {
                    $last_clientid = $clients_deleted_reps->[-1]->{clientid};
                    my $data_for_update = {};
                    foreach my $client_data (@$clients_deleted_reps) {
                        my $deleted_reps;
                        eval {
                            $deleted_reps = from_json($client_data->{deleted_reps});
                        };
                        if ($@) {
                           # Если строка оказалась не jsonом, то создаем хеш с незаполненными полями.
                           $deleted_reps = [map { {uid=>$_, login=>'', fio=>'', phone=>'', email=>''} } 
                                            grep {is_valid_id($_)}        
                                                split(',', $client_data->{deleted_reps})];
                        }

                        my @new_reps_data;
                        my $has_new_data = 0; # Если в обновляемых данных не будет ничего нового, то и нет смысла делать update в базу.
                        foreach my $user (@$deleted_reps) {
                            if (! $user->{login}) {
                                my $passport_info = get_info_by_uid_passport($user->{uid});
                                if ($passport_info->{login}) {
                                    hash_merge $user, hash_cut $passport_info, qw/fio phone email login/;
                                    $has_new_data = 1;
                                }
                            }
                            push @new_reps_data, $user;
                        }
                        $data_for_update->{$client_data->{clientid}} = to_json(\@new_reps_data) 
                            if @new_reps_data && $has_new_data;
                    }

                    do_mass_update_sql(PPC(shard => $shard), 'clients', 
                        clientid => {map {$_ => {deleted_reps => $data_for_update->{$_}}} keys %$data_for_update});
                }
            };
        };
    } while @$clients_deleted_reps > 0 && !$CLIENT_ID;
});

$log->out('FINISH');
