#!/usr/bin/env perl

=head1 DEPLOY

# approved by lena-san
# .migr
[
    {
        type => 'sql',
        webstop => "0",
        db => "ppcdict",
        when => 'before',
        time_estimate => "1s",
        comment => 'нужно проверить, что константа 48000000 здесь и в скрипте идёт впереди текущего max(id) в mds_metadata',
        sql => "CREATE TABLE `inc_mds_id` (
            `mds_id` bigint(20) NOT NULL AUTO_INCREMENT,
            PRIMARY KEY (`mds_id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=48000000 DEFAULT CHARSET=utf8"
    },
    {
        type => 'sql',
        webstop => "0",
        db => "ppc",
        when => 'after',
        time_estimate => "2m",
        sql => "ALTER TABLE mds_metadata MODIFY COLUMN `id` bigint(20) unsigned NOT NULL",
        comment => 'Перед выполнением нужно подождать несколько часов после релиза, выполнять через direct-pt-osc'
    },
    {
        type => 'script',
        when => 'after',
        time_estimate => "30 минут",
        comment => "перекладываем записи в mds_metadata с новым процессом генерации id.
        На id никто кроме mds_custom_names не должен ссылаться"
    }
]

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw(ppc_shards);
use Yandex::DBShards qw/get_new_id_multi/;

$log->out('START');

my $BORDER = 48_000_000; # докуда идут старые id

# сначала перенесём тех, у кого не должно быть записей в mds_custom_names и удалим такие записи
foreach my $shard (ppc_shards()) {
    $log->out("updating a shard: $shard");
    for (my $i = 1; $i < 1e6; $i++) {
        $log->out("iteration $i");
        my $mds_ids = get_one_column_sql(PPC(shard => $shard), "select id from mds_metadata where id < $BORDER and type in (
            'banner_images_uploads',
            'perf_feeds',
            'api_forecast_nameless',
            'api_wordstat_nameless',
            'mod_licenses',
            'api_report_stat'
        ) limit 1000");
        $log->out("got " . (scalar @$mds_ids) . " ids");
        last unless @$mds_ids; # ожидаемый выход из цикла

        my @new_ids = @{get_new_id_multi('mds_id', scalar @$mds_ids)};
        unless (@new_ids && scalar @$mds_ids == scalar @new_ids) {
            $log->out((scalar @$mds_ids) . " != " . (scalar @new_ids));
            next; # что-то пошло не так, попробуем всё заново
        }
        my %subsitution_hash;
        @subsitution_hash{@$mds_ids} = map {{id => $_}} @new_ids;
        $log->out("substitution: " . join ', ', map {$_ . '=>' . $subsitution_hash{$_}->{id}} keys %subsitution_hash);

        do_sql(PPC(shard => $shard), ["delete from mds_custom_names", where => {mds_id => $mds_ids}]);

        do_mass_update_sql(PPC(shard => $shard), 'mds_metadata', 'id', \%subsitution_hash);

        $log->out("updated a batch");
    }
}

foreach my $shard (ppc_shards()) {
    $log->out("updating a shard with names: $shard");

    for (my $i = 1; $i < 1e6; $i++) {
        $log->out("iteration $i");
        my $mds_ids = get_one_column_sql(PPC(shard => $shard), "select id from mds_metadata where id < $BORDER limit 1000");
        $log->out("got " . (scalar @$mds_ids) . " ids");
        last unless @$mds_ids; # ожидаемый выход из цикла

        my @new_ids = @{get_new_id_multi('mds_id', scalar @$mds_ids)};
        unless (@new_ids && scalar @$mds_ids == scalar @new_ids) {
            $log->out((scalar @$mds_ids) . " != " . (scalar @new_ids));
            next;
        }
        my %subsitution_hash;
        @subsitution_hash{@$mds_ids} = map {{id => $_}} @new_ids;
        my %subsitution_hash2;
        @subsitution_hash2{@$mds_ids} = map {{mds_id => $_}} @new_ids;
        $log->out("substitution: " . join ', ', map {$_ . '=>' . $subsitution_hash{$_}->{id}} keys %subsitution_hash);

        do_in_transaction {
            do_sql(PPC(shard => $shard), 'SET SESSION FOREIGN_KEY_CHECKS = 0');
            do_mass_update_sql(PPC(shard => $shard), 'mds_metadata', 'id', \%subsitution_hash);
            do_mass_update_sql(PPC(shard => $shard), 'mds_custom_names', 'mds_id', \%subsitution_hash2);
            do_sql(PPC(shard => $shard), 'SET SESSION FOREIGN_KEY_CHECKS = 1');
        };
        $log->out("updated a batch");
    }
}

$log->out('FINISH');
