#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'секунда-другая',
  comment => 'снимаем тизер у субклиентов агентства ip-anikitin',
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use Settings;
use ScriptHelper;

use PrimitivesIds;
use RBAC2::Extended;
use RBACDirect;
use RBACElementary;

my $LOGIN = 'ip-anikitin';

$log->out('START');

$log->out('Fetching agency subclients');
my $rbac = RBAC2::Extended->get_singleton(1);
my $agency_client_id = get_clientid(login => $LOGIN);
my $agency_uid = rbac_get_chief_rep_of_agency($agency_client_id);
my $subclients = rbac_get_subclients_clientids($rbac, $agency_uid);
$log->out('Got ' . scalar(@$subclients) . ' to remove teaser');

foreach_shard ClientID => $subclients, chunk_size => 100, sub {
    my ($shard, $clientids) = @_;

    my $msg_prefix_guard = $log->msg_prefix_guard("[shard_$shard]");

    $log->out('Deleting clients teasers for ClientIDs:', $clientids);
    do_delete_from_table(PPC(shard => $shard), 'clients_to_force_multicurrency_teaser', where => {ClientID => $clientids});
};

$log->out('FINISH');
