#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr

{
  type => 'script',
  when => 'instructions',
  instructions => '
- можно запускать повторно;
- если один из ppcstatов недоступен, можно запускать выборочно на наборе работающих хостов (--host ppcstat:5 --host ppcstat:6), а затем на проблемном;',
  time_estimate => "до 1 часа",
  comment => "перезаполняем все таблицы order_stat_small_NNNNNN из order_stat_NNNNNN",
}

=cut

use strict;
use warnings;

use my_inc "..";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use DBStat;

use utf8;


my @ppcstat_hosts;
extract_script_params(
    'host=s@' => \@ppcstat_hosts,
) || exit(1);
if (!@ppcstat_hosts) {
    @ppcstat_hosts = sort DBStat->get_db_hosts("");
}

# количество строк в таблице order_stat_NNNNNN которые мы за раз перекидываем в order_stat_small_NNNNNN
my $STAT_ROWS_CHUNK_SIZE = 500_000;

$log->out('START');
$log->out("Working on hosts:", \@ppcstat_hosts);

for my $ppcstat_host (@ppcstat_hosts) {
    $log->msg_prefix("[$ppcstat_host]");

    $log->out("start processing host");

    my $dbh_stat = connect_db( $ppcstat_host );
    my $oids = get_one_column_sql($dbh_stat, 'select OrderID from order_stat_info');
    for my $oid (@$oids) {
        $log->out("trying to update order: $oid");
        $dbh_stat = connect_db( $ppcstat_host );
        my $dbstat = new DBStat(OrderID => $oid, dbh => $dbh_stat);
        eval {
            my $lock_guard = $dbstat->get_order_lock_guard($oid, timeout => 5);
            # бьем даты на чанки N строк, поскольку непонятно как будет работать insert into ... select сразу по десятку миллионов строк
            my $all_dates = get_all_sql($dbh_stat, "select DATE_FORMAT(hitDate, '%Y%m%d') stat_date, count(*) qty from ppcstat_data.order_stat_$oid group by hitDate order by hitDate");
            my $rows_qty = 0;
            my @hit_dates;
            while (my $d = shift @$all_dates) {
                if ($rows_qty && $rows_qty + $d->{qty} > $STAT_ROWS_CHUNK_SIZE) {
                    $dbstat-> _cleanup_and_fill_order_stat_small($oid, $hit_dates[0], $hit_dates[-1], \@hit_dates);
                    $rows_qty = 0;
                    @hit_dates = ();
                }

                $rows_qty += $d->{qty};
                push @hit_dates, $d->{stat_date};
            }

            if ($rows_qty) {
                $dbstat-> _cleanup_and_fill_order_stat_small($oid, $hit_dates[0], $hit_dates[-1], \@hit_dates);
            }
        };

        if ($@) {
            $log->out("Error occured: $@");
        } else {
            $log->out("successful update order: $oid");
        }
    }

    $log->out("finish processing host");

}
