#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'порядка 5 минут',
  comment => 'исправляем statusPostModerate у кошельков, который когда-то выставлялся неправильно',
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw(ppc_shards);
use BS::ResyncQueue qw(bs_resync_camps);

use Yandex::ListUtils qw(chunks);

$log->out('START');

for my $shard (ppc_shards()) {
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard_$shard]");

    $log->out('Fetching wallet cids to fix');
    my $wallet_cids_to_fix = get_one_column_sql(PPC(shard => $shard), ['
        SELECT STRAIGHT_JOIN c.cid
        FROM campaigns c
        INNER JOIN camp_options co ON co.cid = c.cid
        WHERE
                c.type = "wallet"
            AND co.statusPostModerate != "Accepted"
    ']);
    $log->out('Got ' . scalar(@$wallet_cids_to_fix) . ' wallet cids to fix');

    for my $cids_chunk (chunks $wallet_cids_to_fix, 1_000) {
        $log->out('Fixing statusPostModerate for cids:', $cids_chunk);
        do_in_transaction {
            do_update_table(PPC(shard => $shard), 'camp_options', {statusPostModerate => 'Accepted'}, where => {cid => $cids_chunk});
            bs_resync_camps($cids_chunk, priority => 22);
        };
    }
}

$log->out('FINISH');

