#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'instructions',
  instructions => "Запускать в любое время",
  time_estimate => "10 секунд",
  comment => "Создаем клиенту фишечный кошелек и подключаем к нему фишечные кампании"
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::Validate qw/is_valid_id/;

use my_inc '..';

use ScriptHelper;
use Settings;

use DirectContext;
use RBAC2::Extended;
use RBACElementary;
use Wallet;

my $cids = [
    158686,
    4878332,
    5827175,
    5828914,
];
my $ClientID = 355783;

$log->out('START');

my $rbac = eval { RBAC2::Extended->get_singleton(1) } or $log->die("Error initialising RBAC: $@");

my $client_chief_uid = rbac_get_chief_rep_of_client($ClientID);

$log->out("client_chief_uid = $client_chief_uid");

my $context = DirectContext->new({
    UID => $client_chief_uid,
    uid => $client_chief_uid,
    client_chief_uid => $client_chief_uid,
    client_client_id => $ClientID,
    login_rights => {},
    rbac => $rbac,
    site_host => "yandex.ru",
    is_beta => EnvTools::is_beta(),
});

my $result;
eval {
    $result = Wallet::enable_wallet($context, 'YND_FIXED', 0, dont_check_onoff_time => 1);
    1;
} or do {
    $log->out({error => $@});
};

if (is_valid_id($result->{wallet_cid})) {
    $log->out("YND_FIXED wallet_cid: $result->{wallet_cid}");
    do_update_table(PPC(ClientID => $ClientID), 'campaigns', {wallet_cid => $result->{wallet_cid}, statusBsSynced => 'No'}, where => {cid => $cids});
    $log->out("Campaigns updated!");
} else {
    $log->out($result);
}

$log->out('FINISH');

