#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'несколько секунд',
  comment => ' удаляем кошелек-дубликат из БД Директа и RBAC',
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use ScriptHelper;
use Settings;
use RBAC2::Extended;
use RBACDirect;


my $WALLET_CID = 19376176;
my $WALLET_CID_DUP = 19376177;
my $CLIENT_UID = 326776716;

$log->out('START');
$log->out("Deleting campaign $WALLET_CID");

if (get_one_field_sql(PPC(uid => $CLIENT_UID), 'select 1 from campaigns where cid = ? and sum > 0', $WALLET_CID_DUP)) {
    $log->die("Can't delete wallet with sum > 0");
}

$log->out('Deleting from RBAC');
my $rbac = eval { RBAC2::Extended->get_singleton(1) } or $log->die("Error initialising RBAC: $@");
my $errcode = eval {rbac_delete_campaign($rbac, $WALLET_CID_DUP, $CLIENT_UID);};
if ($@) {
    $log->out("rbac die on delete campaign: $@");
} elsif ($errcode) {
    $log->out("rbac error on delete campaign (cid: $WALLET_CID_DUP, code: $errcode)");
}

# привязываем все кампании клиента к "правильному" кошельку (для прода не надо, нужно для ТС)
do_sql(PPC(uid => $CLIENT_UID), "update campaigns set wallet_cid = ? where wallet_cid = ? and uid = ?", $WALLET_CID, $WALLET_CID_DUP, $CLIENT_UID);

my %ppc_tables = (campaigns => 'cid',
                  camp_options => 'cid',
                  camp_secondary_options => 'cid',
                  camp_payments_info => 'cid',
                  wallet_campaigns => 'wallet_cid',
                  );
for my $t (keys %ppc_tables) {
    $log->out("Deleting from table $t");
    my $rows_deleted = do_delete_from_table(PPC(uid => $CLIENT_UID), $t, where => {$ppc_tables{$t} => $WALLET_CID_DUP});
    $log->out(sprintf("Deleted %d rows from table $t", $rows_deleted+0));
}

delete_shard(cid => $WALLET_CID_DUP);

$log->out('FINISH');
